/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class UndeployFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = UndeployFunction.class.getName();
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object[] args = (Object[])context.getArguments();
            Object[] jarFilenameList = (String[])args[0];
            InternalCache cache = (InternalCache)context.getCache();
            JarDeployer jarDeployer = ClassPathLoader.getLatest().getJarDeployer();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            String[] undeployedJars = new String[]{};
            if (ArrayUtils.isEmpty((Object[])jarFilenameList)) {
                List<DeployedJar> jarClassLoaders = jarDeployer.findDeployedJars();
                undeployedJars = new String[jarClassLoaders.size() * 2];
                int index = 0;
                for (DeployedJar jarClassLoader : jarClassLoaders) {
                    undeployedJars[index++] = jarClassLoader.getJarName();
                    try {
                        undeployedJars[index++] = ClassPathLoader.getLatest().getJarDeployer().undeploy(jarClassLoader.getJarName());
                    }
                    catch (IllegalArgumentException iaex) {
                        undeployedJars[index++] = iaex.getMessage();
                    }
                }
            } else {
                ArrayList<Object> undeployedList = new ArrayList<Object>();
                for (Object jarFilename : jarFilenameList) {
                    try {
                        undeployedList.add(jarFilename);
                        undeployedList.add(ClassPathLoader.getLatest().getJarDeployer().undeploy((String)jarFilename));
                    }
                    catch (IllegalArgumentException iaex) {
                        undeployedList.add(iaex.getMessage());
                    }
                }
                undeployedJars = undeployedList.toArray(undeployedJars);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])undeployedJars);
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not undeploy JAR file: {}", (Object)th.getMessage(), (Object)th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

