/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.RegionCommandsUtils;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.util.RegionPath;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class RegionCreateFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = RegionCreateFunction.class.getName();
    public static RegionCreateFunction INSTANCE = new RegionCreateFunction();

    @Override
    public boolean isHA() {
        return false;
    }

    public void execute(FunctionContext context) {
        Region region;
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        RegionFunctionArgs regionCreateArgs = (RegionFunctionArgs)context.getArguments();
        if (regionCreateArgs.isSkipIfExists().booleanValue() && (region = cache.getRegion(regionCreateArgs.getRegionPath())) != null) {
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, true, CliStrings.format("Skipping \"{0}\". Region \"{1}\" already exists.", memberNameOrId, regionCreateArgs.getRegionPath())));
            return;
        }
        try {
            Region<?, ?> createdRegion = RegionCreateFunction.createRegion(cache, regionCreateArgs);
            XmlEntity xmlEntity = new XmlEntity("region", "name", createdRegion.getName());
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("Region \"{0}\" created on \"{1}\"", createdRegion.getFullPath(), memberNameOrId)));
        }
        catch (IllegalStateException e) {
            String exceptionMsg = e.getMessage();
            String localizedString = LocalizedStrings.DiskStore_IS_USED_IN_NONPERSISTENT_REGION.toLocalizedString();
            if (localizedString.equals(e.getMessage())) {
                exceptionMsg = exceptionMsg + " " + CliStrings.format("Use one of these shortcuts: {0}", new Object[]{String.valueOf(RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS)});
            }
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, null));
        }
        catch (IllegalArgumentException e) {
            resultSender.lastResult(this.handleException(memberNameOrId, e.getMessage(), e));
        }
        catch (RegionExistsException e) {
            String exceptionMsg = CliStrings.format("Region with path \"{0}\" already exists on \"{1}\"", regionCreateArgs.getRegionPath(), memberNameOrId);
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, e));
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = CliUtil.stackTraceAsString(e);
            }
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, e));
        }
    }

    private CliFunctionResult handleException(String memberNameOrId, String exceptionMsg, Exception e) {
        if (e != null && logger.isDebugEnabled()) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (exceptionMsg != null) {
            return new CliFunctionResult(memberNameOrId, false, exceptionMsg);
        }
        return new CliFunctionResult(memberNameOrId);
    }

    public static <K, V> Region<?, ?> createRegion(Cache cache, RegionFunctionArgs regionCreateArgs) {
        String cacheWriter;
        String string;
        Set<String> set;
        Set<String> asyncEventQueueIds;
        Set<String> gatewaySenderIds;
        String diskStore;
        EvictionAttributes evictionAttributes;
        RegionFunctionArgs.ExpirationAttrs regionExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs regionExpirationIdleTime;
        RegionFunctionArgs.ExpirationAttrs entryExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs entryExpirationIdleTime;
        Region createdRegion = null;
        RegionShortcut regionShortcut = regionCreateArgs.getRegionShortcut();
        boolean isPartitioned = false;
        RegionFactory factory = null;
        RegionAttributes regionAttributes = null;
        if (regionShortcut != null) {
            regionAttributes = cache.getRegionAttributes(regionShortcut.toString());
            regionCreateArgs.setRegionAttributes(regionAttributes);
        } else {
            regionAttributes = regionCreateArgs.getRegionAttributes();
        }
        isPartitioned = regionAttributes.getPartitionAttributes() != null;
        factory = cache.createRegionFactory(regionAttributes);
        if (isPartitioned) {
            PartitionAttributes partitionAttributes = RegionCreateFunction.extractPartitionAttributes(cache, regionAttributes, regionCreateArgs);
            DataPolicy originalDataPolicy = regionAttributes.getDataPolicy();
            factory.setPartitionAttributes(partitionAttributes);
            factory.setDataPolicy(originalDataPolicy);
        }
        String keyConstraint = regionCreateArgs.getKeyConstraint();
        String valueConstraint = regionCreateArgs.getValueConstraint();
        if (keyConstraint != null && !keyConstraint.isEmpty()) {
            Class keyConstraintClass = CliUtil.forName(keyConstraint, "key-constraint");
            factory.setKeyConstraint(keyConstraintClass);
        }
        if (valueConstraint != null && !valueConstraint.isEmpty()) {
            Class valueConstraintClass = CliUtil.forName(valueConstraint, "value-constraint");
            factory.setValueConstraint(valueConstraintClass);
        }
        if ((entryExpirationIdleTime = regionCreateArgs.getEntryExpirationIdleTime()) != null) {
            factory.setEntryIdleTimeout(entryExpirationIdleTime.convertToExpirationAttributes());
        }
        if ((entryExpirationTTL = regionCreateArgs.getEntryExpirationTTL()) != null) {
            factory.setEntryTimeToLive(entryExpirationTTL.convertToExpirationAttributes());
        }
        if ((regionExpirationIdleTime = regionCreateArgs.getRegionExpirationIdleTime()) != null) {
            factory.setRegionIdleTimeout(regionExpirationIdleTime.convertToExpirationAttributes());
        }
        if ((regionExpirationTTL = regionCreateArgs.getRegionExpirationTTL()) != null) {
            factory.setRegionTimeToLive(regionExpirationTTL.convertToExpirationAttributes());
        }
        if ((evictionAttributes = regionCreateArgs.getEvictionAttributes()) != null) {
            ObjectSizer sizer = evictionAttributes.getObjectSizer();
            if (sizer != null && !(sizer instanceof Declarable)) {
                throw new IllegalArgumentException("eviction-object-sizer must implement both ObjectSizer and Declarable interfaces");
            }
            factory.setEvictionAttributes(evictionAttributes);
        }
        if ((diskStore = regionCreateArgs.getDiskStore()) != null && !diskStore.isEmpty()) {
            factory.setDiskStoreName(diskStore);
        }
        if (regionCreateArgs.isDiskSynchronous() != null) {
            factory.setDiskSynchronous(regionCreateArgs.isDiskSynchronous());
        }
        if (regionCreateArgs.isOffHeap() != null) {
            factory.setOffHeap(regionCreateArgs.isOffHeap());
        }
        if (regionCreateArgs.isStatisticsEnabled() != null) {
            factory.setStatisticsEnabled(regionCreateArgs.isStatisticsEnabled());
        }
        if (regionCreateArgs.isEnableAsyncConflation() != null) {
            factory.setEnableAsyncConflation(regionCreateArgs.isEnableAsyncConflation());
        }
        if (regionCreateArgs.isEnableSubscriptionConflation() != null) {
            factory.setEnableSubscriptionConflation(regionCreateArgs.isEnableSubscriptionConflation());
        }
        if ((gatewaySenderIds = regionCreateArgs.getGatewaySenderIds()) != null && !gatewaySenderIds.isEmpty()) {
            for (String string2 : gatewaySenderIds) {
                factory.addGatewaySenderId(string2);
            }
        }
        if ((asyncEventQueueIds = regionCreateArgs.getAsyncEventQueueIds()) != null && !asyncEventQueueIds.isEmpty()) {
            for (String string3 : asyncEventQueueIds) {
                factory.addAsyncEventQueueId(string3);
            }
        }
        if (regionCreateArgs.isConcurrencyChecksEnabled() != null) {
            factory.setConcurrencyChecksEnabled(regionCreateArgs.isConcurrencyChecksEnabled());
        }
        if (regionCreateArgs.getConcurrencyLevel() != null) {
            factory.setConcurrencyLevel(regionCreateArgs.getConcurrencyLevel());
        }
        if (regionCreateArgs.isCloningEnabled() != null) {
            factory.setCloningEnabled(regionCreateArgs.isCloningEnabled());
        }
        if (regionCreateArgs.isMcastEnabled() != null) {
            factory.setMulticastEnabled(regionCreateArgs.isMcastEnabled());
        }
        if ((set = regionCreateArgs.getCacheListeners()) != null && !set.isEmpty()) {
            for (String cacheListener : set) {
                Class cacheListenerKlass = CliUtil.forName(cacheListener, "cache-listener");
                factory.addCacheListener((CacheListener)CliUtil.newInstance(cacheListenerKlass, "cache-listener"));
            }
        }
        if (regionCreateArgs.getCompressor() != null) {
            Class clazz = CliUtil.forName(regionCreateArgs.getCompressor(), "compressor");
            factory.setCompressor((Compressor)CliUtil.newInstance(clazz, "compressor"));
        }
        if ((string = regionCreateArgs.getCacheLoader()) != null) {
            Class cacheLoaderKlass = CliUtil.forName(string, "cache-loader");
            factory.setCacheLoader((CacheLoader)CliUtil.newInstance(cacheLoaderKlass, "cache-loader"));
        }
        if ((cacheWriter = regionCreateArgs.getCacheWriter()) != null) {
            Class cacheWriterKlass = CliUtil.forName(cacheWriter, "cache-writer");
            factory.setCacheWriter((CacheWriter)CliUtil.newInstance(cacheWriterKlass, "cache-writer"));
        }
        String regionPath = regionCreateArgs.getRegionPath();
        RegionPath regionPathData = new RegionPath(regionPath);
        String regionName = regionPathData.getName();
        String parentRegionPath = regionPathData.getParent();
        if (parentRegionPath != null && !"/".equals(parentRegionPath)) {
            Region parentRegion = cache.getRegion(parentRegionPath);
            createdRegion = factory.createSubregion(parentRegion, regionName);
        } else {
            createdRegion = factory.create(regionName);
        }
        return createdRegion;
    }

    private static <K, V> PartitionAttributes<K, V> extractPartitionAttributes(Cache cache, RegionAttributes<K, V> regionAttributes, RegionFunctionArgs regionCreateArgs) {
        RegionFunctionArgs.PartitionArgs partitionArgs = regionCreateArgs.getPartitionArgs();
        PartitionAttributesFactory prAttrFactory = null;
        PartitionAttributes partitionAttributes = regionAttributes.getPartitionAttributes();
        prAttrFactory = partitionAttributes != null ? new PartitionAttributesFactory(partitionAttributes) : new PartitionAttributesFactory();
        String colocatedWith = partitionArgs.getPrColocatedWith();
        if (colocatedWith != null) {
            Region colocatedWithRegion = cache.getRegion(colocatedWith);
            if (colocatedWithRegion == null) {
                throw new IllegalArgumentException(CliStrings.format("colocated-with \"{0}\" does not exists.", (Object)colocatedWith));
            }
            if (!colocatedWithRegion.getAttributes().getDataPolicy().withPartitioning()) {
                throw new IllegalArgumentException(CliStrings.format("colocated-with \"{0}\" is not a Partitioned Region.", (Object)colocatedWith));
            }
            prAttrFactory.setColocatedWith(colocatedWith);
        }
        if (partitionArgs.getPrLocalMaxMemory() != null) {
            prAttrFactory.setLocalMaxMemory(partitionArgs.getPrLocalMaxMemory());
        }
        if (partitionArgs.getPrTotalMaxMemory() != null) {
            prAttrFactory.setTotalMaxMemory(partitionArgs.getPrTotalMaxMemory());
        }
        if (partitionArgs.getPrTotalNumBuckets() != null) {
            prAttrFactory.setTotalNumBuckets(partitionArgs.getPrTotalNumBuckets());
        }
        if (partitionArgs.getPrRedundantCopies() != null) {
            prAttrFactory.setRedundantCopies(partitionArgs.getPrRedundantCopies());
        }
        if (partitionArgs.getPrRecoveryDelay() != null) {
            prAttrFactory.setRecoveryDelay(partitionArgs.getPrRecoveryDelay());
        }
        if (partitionArgs.getPrStartupRecoveryDelay() != null) {
            prAttrFactory.setStartupRecoveryDelay(partitionArgs.getPrStartupRecoveryDelay());
        }
        if (regionCreateArgs.getPartitionArgs().getPartitionResolver() != null) {
            Class<PartitionResolver> partitionResolverClass = RegionCreateFunction.forName(regionCreateArgs.getPartitionArgs().getPartitionResolver(), "partition-resolver");
            prAttrFactory.setPartitionResolver(RegionCreateFunction.newInstance(partitionResolverClass, "partition-resolver"));
        }
        return prAttrFactory.create();
    }

    private static Class<PartitionResolver> forName(String className, String neededFor) {
        if (StringUtils.isBlank((String)className)) {
            throw new IllegalArgumentException(CliStrings.format("{0} is an invalid Partition Resolver.", className, neededFor));
        }
        try {
            return ClassPathLoader.getLatest().forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", className, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", className, neededFor), e);
        }
    }

    private static PartitionResolver newInstance(Class<PartitionResolver> klass, String neededFor) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
    }

    @Override
    public String getId() {
        return ID;
    }
}

