/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.Index;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.IndexDetails;

public class ListIndexFunction
extends FunctionAdapter
implements InternalEntity {
    @Override
    public String getId() {
        return ListIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        try {
            HashSet<IndexDetails> indexDetailsSet = new HashSet<IndexDetails>();
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            for (Index index : cache.getQueryService().getIndexes()) {
                indexDetailsSet.add(new IndexDetails(member, index));
            }
            context.getResultSender().lastResult(indexDetailsSet);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }
}

