/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.domain.CacheServerInfo;
import org.apache.geode.management.internal.cli.domain.MemberInformation;

public class GetMemberInformationFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public String getId() {
        return GetMemberInformationFunction.class.getName();
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    public void execute(FunctionContext functionContext) {
        try {
            Cache cache = functionContext.getCache();
            InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
            DistributionConfig config = system.getConfig();
            String serverBindAddress = config.getServerBindAddress();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemberInformation memberInfo = new MemberInformation();
            memberInfo.setGroups(config.getGroups());
            memberInfo.setLogFilePath(config.getLogFile().getCanonicalPath());
            memberInfo.setStatArchiveFilePath(config.getStatisticArchiveFile().getCanonicalPath());
            memberInfo.setWorkingDirPath(System.getProperty("user.dir"));
            memberInfo.setCacheXmlFilePath(config.getCacheXmlFile().getCanonicalPath());
            memberInfo.setLocators(config.getLocators());
            memberInfo.setServerBindAddress(serverBindAddress);
            memberInfo.setOffHeapMemorySize(config.getOffHeapMemorySize());
            MemoryUsage memUsage = memoryMXBean.getHeapMemoryUsage();
            memberInfo.setHeapUsage(Long.toString(this.bytesToMeg(memUsage.getUsed())));
            memberInfo.setMaxHeapSize(Long.toString(this.bytesToMeg(memUsage.getMax())));
            memberInfo.setInitHeapSize(Long.toString(this.bytesToMeg(memUsage.getInit())));
            memberInfo.setHostedRegions(CliUtil.getAllRegionNames());
            List<CacheServer> csList = cache.getCacheServers();
            if (csList != null) {
                memberInfo.setServer(true);
                for (CacheServer cs : csList) {
                    String bindAddress = cs.getBindAddress();
                    int port = cs.getPort();
                    boolean isRunning = cs.isRunning();
                    CacheServerInfo cacheServerInfo = new CacheServerInfo(bindAddress, port, isRunning);
                    memberInfo.addCacheServerInfo(cacheServerInfo);
                }
                Map allConnectedClients = InternalClientMembership.getStatusForAllClientsIgnoreSubscriptionStatus();
                Iterator it = allConnectedClients.keySet().iterator();
                int numConnections = 0;
                while (it.hasNext()) {
                    CacheClientStatus status = (CacheClientStatus)allConnectedClients.get(it.next());
                    numConnections += status.getNumberOfConnections();
                }
                memberInfo.setClientCount(numConnections);
            } else {
                memberInfo.setServer(false);
            }
            functionContext.getResultSender().lastResult(memberInfo);
        }
        catch (CacheClosedException e) {
            functionContext.getResultSender().sendException(e);
        }
        catch (Exception e) {
            functionContext.getResultSender().sendException(e);
        }
    }

    private long bytesToMeg(long bytes) {
        return bytes / 0x100000L;
    }
}

