/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewaySenderFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class GatewaySenderCreateFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = GatewaySenderCreateFunction.class.getName();
    public static GatewaySenderCreateFunction INSTANCE = new GatewaySenderCreateFunction();

    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        GatewaySenderFunctionArgs gatewaySenderCreateArgs = (GatewaySenderFunctionArgs)context.getArguments();
        try {
            GatewaySender createdGatewaySender = this.createGatewaySender(cache, gatewaySenderCreateArgs);
            XmlEntity xmlEntity = new XmlEntity("gateway-sender", "id", gatewaySenderCreateArgs.getId());
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("GatewaySender \"{0}\" created on \"{1}\"", createdGatewaySender.getId(), memberNameOrId)));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, e, null));
        }
    }

    private GatewaySender createGatewaySender(Cache cache, GatewaySenderFunctionArgs gatewaySenderCreateArgs) {
        String[] gatewayTransportFilters;
        String[] gatewayEventFilters;
        Boolean isDiskSynchronous;
        String diskStoreName;
        Boolean isPersistenceEnabled;
        Integer dispatcherThreads;
        Integer alertThreshold;
        Integer socketReadTimeout;
        Integer socketBufferSize;
        Boolean enableBatchConflation;
        Integer batchTimeInterval;
        Integer batchSize;
        Integer maxQueueMemory;
        Boolean manualStart;
        GatewaySenderFactory gateway = cache.createGatewaySenderFactory();
        Boolean isParallel = gatewaySenderCreateArgs.isParallel();
        if (isParallel != null) {
            gateway.setParallel(isParallel);
        }
        if ((manualStart = gatewaySenderCreateArgs.isManualStart()) != null) {
            gateway.setManualStart(manualStart);
        }
        if ((maxQueueMemory = gatewaySenderCreateArgs.getMaxQueueMemory()) != null) {
            gateway.setMaximumQueueMemory(maxQueueMemory);
        }
        if ((batchSize = gatewaySenderCreateArgs.getBatchSize()) != null) {
            gateway.setBatchSize(batchSize);
        }
        if ((batchTimeInterval = gatewaySenderCreateArgs.getBatchTimeInterval()) != null) {
            gateway.setBatchTimeInterval(batchTimeInterval);
        }
        if ((enableBatchConflation = gatewaySenderCreateArgs.isBatchConflationEnabled()) != null) {
            gateway.setBatchConflationEnabled(enableBatchConflation);
        }
        if ((socketBufferSize = gatewaySenderCreateArgs.getSocketBufferSize()) != null) {
            gateway.setSocketBufferSize(socketBufferSize);
        }
        if ((socketReadTimeout = gatewaySenderCreateArgs.getSocketReadTimeout()) != null) {
            gateway.setSocketReadTimeout(socketReadTimeout);
        }
        if ((alertThreshold = gatewaySenderCreateArgs.getAlertThreshold()) != null) {
            gateway.setAlertThreshold(alertThreshold);
        }
        if ((dispatcherThreads = gatewaySenderCreateArgs.getDispatcherThreads()) != null && dispatcherThreads > 1) {
            gateway.setDispatcherThreads(dispatcherThreads);
            String orderPolicy = gatewaySenderCreateArgs.getOrderPolicy();
            gateway.setOrderPolicy(GatewaySender.OrderPolicy.valueOf(orderPolicy));
        }
        if ((isPersistenceEnabled = gatewaySenderCreateArgs.isPersistenceEnabled()) != null) {
            gateway.setPersistenceEnabled(isPersistenceEnabled);
        }
        if ((diskStoreName = gatewaySenderCreateArgs.getDiskStoreName()) != null) {
            gateway.setDiskStoreName(diskStoreName);
        }
        if ((isDiskSynchronous = gatewaySenderCreateArgs.isDiskSynchronous()) != null) {
            gateway.setDiskSynchronous(isDiskSynchronous);
        }
        if ((gatewayEventFilters = gatewaySenderCreateArgs.getGatewayEventFilter()) != null) {
            for (String gatewayEventFilter : gatewayEventFilters) {
                Class gatewayEventFilterKlass = GatewaySenderCreateFunction.forName(gatewayEventFilter, "gateway-event-filter");
                gateway.addGatewayEventFilter((GatewayEventFilter)GatewaySenderCreateFunction.newInstance(gatewayEventFilterKlass, "gateway-event-filter"));
            }
        }
        if ((gatewayTransportFilters = gatewaySenderCreateArgs.getGatewayTransportFilter()) != null) {
            for (String gatewayTransportFilter : gatewayTransportFilters) {
                Class gatewayTransportFilterKlass = GatewaySenderCreateFunction.forName(gatewayTransportFilter, "gateway-transport-filter");
                gateway.addGatewayTransportFilter((GatewayTransportFilter)GatewaySenderCreateFunction.newInstance(gatewayTransportFilterKlass, "gateway-transport-filter"));
            }
        }
        return gateway.create(gatewaySenderCreateArgs.getId(), gatewaySenderCreateArgs.getRemoteDistributedSystemId());
    }

    private static Class forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    private static Object newInstance(Class klass, String neededFor) {
        Object instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    @Override
    public String getId() {
        return ID;
    }
}

