/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import joptsimple.internal.Strings;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewayReceiverFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class GatewayReceiverCreateFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = GatewayReceiverCreateFunction.class.getName();
    public static GatewayReceiverCreateFunction INSTANCE = new GatewayReceiverCreateFunction();

    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        GatewayReceiverFunctionArgs gatewayReceiverCreateArgs = (GatewayReceiverFunctionArgs)context.getArguments();
        try {
            GatewayReceiver createdGatewayReceiver = this.createGatewayReceiver(cache, gatewayReceiverCreateArgs);
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (gatewayReceiverCreateArgs.getStartPort() != null) {
                attributes.put("start-port", gatewayReceiverCreateArgs.getStartPort().toString());
            }
            if (gatewayReceiverCreateArgs.getEndPort() != null) {
                attributes.put("end-port", gatewayReceiverCreateArgs.getEndPort().toString());
            }
            if (gatewayReceiverCreateArgs.getBindAddress() != null) {
                attributes.put("bind-address", gatewayReceiverCreateArgs.getBindAddress());
            }
            XmlEntity xmlEntity = XmlEntity.builder().withType("gateway-receiver").withAttributes(attributes).build();
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("GatewayReceiver created on member \"{0}\" and will listen on the port \"{1}\"", memberNameOrId, createdGatewayReceiver.getPort())));
        }
        catch (IllegalStateException e) {
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, e, e.getMessage()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, e, e.getMessage()));
        }
    }

    GatewayReceiver createGatewayReceiver(Cache cache, GatewayReceiverFunctionArgs gatewayReceiverCreateArgs) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        String hostnameForSenders;
        String[] gatewayTransportFilters;
        Boolean manualStart;
        Integer socketBufferSize;
        Integer maxTimeBetweenPings;
        String bindAddress;
        Integer endPort;
        GatewayReceiverFactory gatewayReceiverFactory = cache.createGatewayReceiverFactory();
        Integer startPort = gatewayReceiverCreateArgs.getStartPort();
        if (startPort != null) {
            gatewayReceiverFactory.setStartPort(startPort);
        }
        if ((endPort = gatewayReceiverCreateArgs.getEndPort()) != null) {
            gatewayReceiverFactory.setEndPort(endPort);
        }
        if ((bindAddress = gatewayReceiverCreateArgs.getBindAddress()) != null) {
            gatewayReceiverFactory.setBindAddress(bindAddress);
        }
        if ((maxTimeBetweenPings = gatewayReceiverCreateArgs.getMaximumTimeBetweenPings()) != null) {
            gatewayReceiverFactory.setMaximumTimeBetweenPings(maxTimeBetweenPings);
        }
        if ((socketBufferSize = gatewayReceiverCreateArgs.getSocketBufferSize()) != null) {
            gatewayReceiverFactory.setSocketBufferSize(socketBufferSize);
        }
        if ((manualStart = gatewayReceiverCreateArgs.isManualStart()) != null) {
            gatewayReceiverFactory.setManualStart(manualStart);
        }
        if ((gatewayTransportFilters = gatewayReceiverCreateArgs.getGatewayTransportFilters()) != null) {
            for (String gatewayTransportFilter : gatewayTransportFilters) {
                gatewayReceiverFactory.addGatewayTransportFilter((GatewayTransportFilter)this.newInstance(gatewayTransportFilter));
            }
        }
        if ((hostnameForSenders = gatewayReceiverCreateArgs.getHostnameForSenders()) != null) {
            gatewayReceiverFactory.setHostnameForSenders(hostnameForSenders);
        }
        return gatewayReceiverFactory.create();
    }

    private Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        return ClassPathLoader.getLatest().forName(className).newInstance();
    }

    @Override
    public String getId() {
        return ID;
    }
}

