/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class FetchRegionAttributesFunction
extends FunctionAdapter {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 4366812590788342070L;
    private static final String ID = FetchRegionAttributesFunction.class.getName();
    public static FetchRegionAttributesFunction INSTANCE = new FetchRegionAttributesFunction();

    @Override
    public boolean isHA() {
        return false;
    }

    public void execute(FunctionContext context) {
        try {
            Cache cache = context.getCache();
            String regionPath = (String)context.getArguments();
            if (regionPath == null) {
                throw new IllegalArgumentException("Specify a valid name");
            }
            RegionAttributes result = FetchRegionAttributesFunction.getRegionAttributes(cache, regionPath);
            context.getResultSender().lastResult(result);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            context.getResultSender().lastResult(e);
        }
    }

    public static <K, V> RegionAttributes<K, V> getRegionAttributes(Cache cache, String regionPath) {
        Region foundRegion = cache.getRegion(regionPath);
        if (foundRegion == null) {
            throw new IllegalArgumentException(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "template-region", regionPath));
        }
        AttributesFactory afactory = new AttributesFactory(foundRegion.getAttributes());
        return afactory.create();
    }

    @Override
    public String getId() {
        return ID;
    }
}

