/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogLevel;
import org.apache.geode.management.internal.cli.util.ExportLogsCacheWriter;
import org.apache.geode.management.internal.cli.util.LogExporter;
import org.apache.geode.management.internal.cli.util.LogFilter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ExportLogsFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String EXPORT_LOGS_REGION = "__exportLogsRegion";
    private static final long serialVersionUID = 1L;
    private static final int BUFFER_SIZE = 1024;

    public void execute(FunctionContext context) {
        try {
            LogFilter logFilter;
            Path exportedZipFile;
            InternalCache cache = (InternalCache)context.getCache();
            DistributionConfig config = cache.getInternalDistributedSystem().getConfig();
            String memberId = cache.getDistributedSystem().getMemberId();
            logger.info("ExportLogsFunction started for member {}", (Object)memberId);
            Region exportLogsRegion = ExportLogsFunction.createOrGetExistingExportLogsRegion(false, cache);
            Args args = (Args)context.getArguments();
            File baseLogFile = null;
            File baseStatsFile = null;
            if (args.isIncludeLogs() && !config.getLogFile().toString().isEmpty()) {
                baseLogFile = config.getLogFile().getAbsoluteFile();
            }
            if (args.isIncludeStats() && !config.getStatisticArchiveFile().toString().isEmpty()) {
                baseStatsFile = config.getStatisticArchiveFile().getAbsoluteFile();
            }
            if ((exportedZipFile = new LogExporter(logFilter = new LogFilter(args.getLogLevel(), args.isThisLogLevelOnly(), args.getStartTime(), args.getEndTime()), baseLogFile, baseStatsFile).export()) == null) {
                context.getResultSender().lastResult(null);
                return;
            }
            logger.info("Streaming zipped file: " + exportedZipFile.toString());
            try (FileInputStream inputStream = new FileInputStream(exportedZipFile.toFile());){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    if (bytesRead == 1024) {
                        exportLogsRegion.put(memberId, buffer);
                        continue;
                    }
                    exportLogsRegion.put(memberId, Arrays.copyOfRange(buffer, 0, bytesRead));
                }
            }
            context.getResultSender().lastResult(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            context.getResultSender().sendException(e);
        }
    }

    public static Region createOrGetExistingExportLogsRegion(boolean isInitiatingMember, InternalCache cache) throws IOException, ClassNotFoundException {
        Region exportLogsRegion = cache.getRegion(EXPORT_LOGS_REGION);
        if (exportLogsRegion == null) {
            AttributesFactory regionAttrsFactory = new AttributesFactory();
            regionAttrsFactory.setDataPolicy(DataPolicy.EMPTY);
            regionAttrsFactory.setScope(Scope.DISTRIBUTED_ACK);
            if (isInitiatingMember) {
                regionAttrsFactory.setCacheWriter(new ExportLogsCacheWriter());
            }
            InternalRegionArguments internalArgs = new InternalRegionArguments();
            internalArgs.setIsUsedForMetaRegion(true);
            exportLogsRegion = cache.createVMRegion(EXPORT_LOGS_REGION, regionAttrsFactory.create(), internalArgs);
        }
        return exportLogsRegion;
    }

    public static void destroyExportLogsRegion(InternalCache cache) {
        Region exportLogsRegion = cache.getRegion(EXPORT_LOGS_REGION);
        if (exportLogsRegion == null) {
            return;
        }
        exportLogsRegion.destroyRegion();
    }

    @Override
    public boolean isHA() {
        return false;
    }

    public static LocalDateTime parseTime(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss/SSS/z");
            return df.parse(dateString).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
                return df.parse(dateString).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            catch (ParseException e1) {
                return null;
            }
        }
    }

    public static class Args
    implements Serializable {
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private Level logLevel;
        private boolean thisLogLevelOnly;
        private boolean includeLogs;
        private boolean includeStats;

        public Args(String startTime, String endTime, String logLevel, boolean logLevelOnly, boolean logsOnly, boolean statsOnly) {
            this.startTime = ExportLogsFunction.parseTime(startTime);
            this.endTime = ExportLogsFunction.parseTime(endTime);
            this.logLevel = StringUtils.isBlank((String)logLevel) ? LogLevel.getLevel("ALL") : LogLevel.getLevel(logLevel);
            this.thisLogLevelOnly = logLevelOnly;
            this.includeLogs = !statsOnly;
            this.includeStats = !logsOnly;
        }

        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        public LocalDateTime getEndTime() {
            return this.endTime;
        }

        public Level getLogLevel() {
            return this.logLevel;
        }

        public boolean isThisLogLevelOnly() {
            return this.thisLogLevelOnly;
        }

        public boolean isIncludeLogs() {
            return this.includeLogs;
        }

        public boolean isIncludeStats() {
            return this.includeStats;
        }
    }
}

