/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.snapshot.SnapshotOptionsImpl;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class ExportDataFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        String[] args = (String[])context.getArguments();
        if (args.length < 3) {
            throw new IllegalStateException("Arguments length does not match required length. Export command may have been sent from incompatible older version");
        }
        String regionName = args[0];
        String fileName = args[1];
        boolean parallel = Boolean.parseBoolean(args[2]);
        try {
            File exportFile;
            Cache cache = context.getCache();
            Region region = cache.getRegion(regionName);
            String hostName = cache.getDistributedSystem().getDistributedMember().getHost();
            if (region != null) {
                RegionSnapshotService snapshotService = region.getSnapshotService();
                exportFile = new File(fileName);
                if (parallel) {
                    SnapshotOptions options = new SnapshotOptionsImpl().setParallelMode(true);
                    snapshotService.save(exportFile, SnapshotOptions.SnapshotFormat.GEMFIRE, options);
                } else {
                    snapshotService.save(exportFile, SnapshotOptions.SnapshotFormat.GEMFIRE);
                }
            } else {
                throw new IllegalArgumentException(CliStrings.format("Region : {0} not found", (Object)regionName));
            }
            String successMessage = CliStrings.format("Data successfully exported from region : {0} to file : {1} on host : {2}", regionName, exportFile.getCanonicalPath(), hostName);
            context.getResultSender().lastResult(successMessage);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return ExportDataFunction.class.getName();
    }
}

