/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class DestroyIndexFunction
implements Function,
InternalEntity {
    private static final long serialVersionUID = -868082551095130315L;

    public void execute(FunctionContext context) {
        CliFunctionResult result;
        IndexInfo indexInfo = (IndexInfo)context.getArguments();
        String memberId = null;
        try {
            Cache cache = context.getCache();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            String indexName = indexInfo.getIndexName();
            String regionPath = indexInfo.getRegionPath();
            XmlEntity xmlEntity = new XmlEntity("region", "name", regionPath, "index", "name", indexName);
            if (regionPath != null && !regionPath.isEmpty()) {
                Region region = cache.getRegion(regionPath);
                if (region != null) {
                    if (indexName == null || indexName.isEmpty()) {
                        queryService.removeIndexes(region);
                        result = new CliFunctionResult(memberId, xmlEntity, "Destroyed all indexes on region " + regionPath);
                    } else {
                        Index index = queryService.getIndex(region, indexName);
                        if (index != null) {
                            queryService.removeIndex(index);
                            result = new CliFunctionResult(memberId, xmlEntity, "Destroyed index " + indexName + " on region " + regionPath);
                        } else {
                            result = indexInfo.isIfExists() ? new CliFunctionResult(memberId, true, "Index " + indexName + " not found - skipped") : new CliFunctionResult(memberId, false, CliStrings.format("Index named \"{0}\" not found", (Object)indexName));
                        }
                    }
                } else {
                    result = new CliFunctionResult(memberId, false, CliStrings.format("Region \"{0}\" not found", (Object)regionPath));
                }
            } else if (indexName == null || indexName.isEmpty()) {
                queryService.removeIndexes();
                result = new CliFunctionResult(memberId, xmlEntity, "Destroyed all indexes");
            } else {
                boolean indexRemoved = this.removeIndexByName(indexName, queryService);
                result = indexRemoved ? new CliFunctionResult(memberId, xmlEntity, "Destroyed index " + indexName) : (indexInfo.isIfExists() ? new CliFunctionResult(memberId, true, "Index " + indexName + " not found - skipped") : new CliFunctionResult(memberId, false, CliStrings.format("Index named \"{0}\" not found", (Object)indexName)));
            }
        }
        catch (CacheClosedException e) {
            result = new CliFunctionResult(memberId, e, e.getMessage());
        }
        catch (Exception e) {
            result = new CliFunctionResult(memberId, e, e.getMessage());
        }
        context.getResultSender().lastResult(result);
    }

    private boolean removeIndexByName(String name, QueryService queryService) {
        List indexes = (List)queryService.getIndexes();
        boolean removed = false;
        if (indexes != null) {
            for (Index index : indexes) {
                if (!index.getName().equals(name)) continue;
                queryService.removeIndex(index);
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public String getId() {
        return DestroyIndexFunction.class.getName();
    }
}

