/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.logging.log4j.Logger;

public class DescribeDiskStoreFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final Set<DataPolicy> PERSISTENT_DATA_POLICIES = new HashSet<DataPolicy>(2);

    protected static void assertState(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    public void init(Properties props) {
    }

    public void execute(FunctionContext context) {
        Cache cache = context.getCache();
        try {
            if (cache instanceof InternalCache) {
                InternalCache gemfireCache = (InternalCache)cache;
                InternalDistributedMember member = gemfireCache.getMyId();
                String diskStoreName = (String)context.getArguments();
                String memberId = member.getId();
                String memberName = member.getName();
                DiskStore diskStore = gemfireCache.findDiskStore(diskStoreName);
                if (diskStore != null) {
                    DiskStoreDetails diskStoreDetails = new DiskStoreDetails(diskStore.getDiskStoreUUID(), diskStore.getName(), memberId, memberName);
                    diskStoreDetails.setAllowForceCompaction(diskStore.getAllowForceCompaction());
                    diskStoreDetails.setAutoCompact(diskStore.getAutoCompact());
                    diskStoreDetails.setCompactionThreshold(diskStore.getCompactionThreshold());
                    diskStoreDetails.setMaxOplogSize(diskStore.getMaxOplogSize());
                    diskStoreDetails.setQueueSize(diskStore.getQueueSize());
                    diskStoreDetails.setTimeInterval(diskStore.getTimeInterval());
                    diskStoreDetails.setWriteBufferSize(diskStore.getWriteBufferSize());
                    diskStoreDetails.setDiskUsageWarningPercentage(Float.valueOf(diskStore.getDiskUsageWarningPercentage()));
                    diskStoreDetails.setDiskUsageCriticalPercentage(Float.valueOf(diskStore.getDiskUsageCriticalPercentage()));
                    this.setDiskDirDetails(diskStore, diskStoreDetails);
                    this.setRegionDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setCacheServerDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setGatewayDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setPdxSerializationDetails(gemfireCache, diskStore, diskStoreDetails);
                    this.setAsyncEventQueueDetails(gemfireCache, diskStore, diskStoreDetails);
                    context.getResultSender().lastResult(diskStoreDetails);
                } else {
                    context.getResultSender().sendException(new EntityNotFoundException(String.format("A disk store with name (%1$s) was not found on member (%2$s).", diskStoreName, memberName)));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while executing 'describe disk-store': {}!", (Object)e.getMessage(), (Object)e);
            context.getResultSender().sendException(e);
        }
    }

    private void setDiskDirDetails(DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        Integer[] diskDirSizes;
        File[] diskDirs = diskStore.getDiskDirs();
        DescribeDiskStoreFunction.assertState(diskDirs.length == (diskDirSizes = ArrayUtils.toIntegerArray(diskStore.getDiskDirSizes())).length, "The number of disk directories with a specified size (%1$d) does not match the number of disk directories (%2$d)!", diskDirSizes.length, diskDirs.length);
        for (int index = 0; index < diskDirs.length; ++index) {
            diskStoreDetails.add(new DiskStoreDetails.DiskDirDetails(diskDirs[index].getAbsolutePath(), ArrayUtils.getElementAtIndex(diskDirSizes, index, 0)));
        }
    }

    protected String getDiskStoreName(Region region) {
        return StringUtils.defaultIfBlank((String)region.getAttributes().getDiskStoreName(), (String)"DEFAULT");
    }

    protected boolean isOverflowToDisk(Region region) {
        return region.getAttributes().getEvictionAttributes() != null && EvictionAction.OVERFLOW_TO_DISK.equals(region.getAttributes().getEvictionAttributes().getAction());
    }

    protected boolean isPersistent(Region region) {
        return region.getAttributes().getDataPolicy().withPersistence();
    }

    protected boolean isUsingDiskStore(Region region, DiskStore diskStore) {
        return (this.isPersistent(region) || this.isOverflowToDisk(region)) && ObjectUtils.equals(this.getDiskStoreName(region), diskStore.getName());
    }

    protected void setRegionDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (Region<?, ?> region : cache.rootRegions()) {
            this.setRegionDetails(region, diskStore, diskStoreDetails);
        }
    }

    private void setRegionDetails(Region<?, ?> region, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        if (this.isUsingDiskStore(region, diskStore)) {
            String regionFullPath = region.getFullPath();
            DiskStoreDetails.RegionDetails regionDetails = new DiskStoreDetails.RegionDetails(regionFullPath, StringUtils.defaultIfBlank((String)region.getName(), (String)regionFullPath));
            regionDetails.setOverflowToDisk(this.isOverflowToDisk(region));
            regionDetails.setPersistent(this.isPersistent(region));
            diskStoreDetails.add(regionDetails);
        }
        for (Region<?, ?> subregion : region.subregions(false)) {
            this.setRegionDetails(subregion, diskStore, diskStoreDetails);
        }
    }

    protected String getDiskStoreName(CacheServer cacheServer) {
        return cacheServer.getClientSubscriptionConfig() == null ? null : StringUtils.defaultIfBlank((String)cacheServer.getClientSubscriptionConfig().getDiskStoreName(), (String)"DEFAULT");
    }

    protected boolean isUsingDiskStore(CacheServer cacheServer, DiskStore diskStore) {
        return ObjectUtils.equals(this.getDiskStoreName(cacheServer), diskStore.getName());
    }

    protected void setCacheServerDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (CacheServer cacheServer : cache.getCacheServers()) {
            if (!this.isUsingDiskStore(cacheServer, diskStore)) continue;
            DiskStoreDetails.CacheServerDetails cacheServerDetails = new DiskStoreDetails.CacheServerDetails(cacheServer.getBindAddress(), cacheServer.getPort());
            cacheServerDetails.setHostName(cacheServer.getHostnameForClients());
            diskStoreDetails.add(cacheServerDetails);
        }
    }

    protected String getDiskStoreName(GatewaySender gateway) {
        return StringUtils.defaultIfBlank((String)gateway.getDiskStoreName(), (String)"DEFAULT");
    }

    protected boolean isPersistent(GatewaySender gateway) {
        return gateway.isPersistenceEnabled();
    }

    protected boolean isUsingDiskStore(GatewaySender gateway, DiskStore diskStore) {
        return ObjectUtils.equals(this.getDiskStoreName(gateway), diskStore.getName());
    }

    protected void setGatewayDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (GatewaySender gatewaySender : cache.getGatewaySenders()) {
            if (!this.isUsingDiskStore(gatewaySender, diskStore)) continue;
            DiskStoreDetails.GatewayDetails gatewayDetails = new DiskStoreDetails.GatewayDetails(gatewaySender.getId());
            gatewayDetails.setPersistent(this.isPersistent(gatewaySender));
            diskStoreDetails.add(gatewayDetails);
        }
    }

    protected void setPdxSerializationDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        if (cache.getPdxPersistent()) {
            String diskStoreName = StringUtils.defaultIfBlank((String)cache.getPdxDiskStore(), (String)"DEFAULT");
            diskStoreDetails.setPdxSerializationMetaDataStored(ObjectUtils.equals(diskStoreName, diskStore.getName()));
        }
    }

    protected String getDiskStoreName(AsyncEventQueue queue) {
        return StringUtils.defaultIfBlank((String)queue.getDiskStoreName(), (String)"DEFAULT");
    }

    protected boolean isUsingDiskStore(AsyncEventQueue queue, DiskStore diskStore) {
        return queue.isPersistent() && ObjectUtils.equals(this.getDiskStoreName(queue), diskStore.getName());
    }

    protected void setAsyncEventQueueDetails(InternalCache cache, DiskStore diskStore, DiskStoreDetails diskStoreDetails) {
        for (AsyncEventQueue queue : cache.getAsyncEventQueues()) {
            if (!this.isUsingDiskStore(queue, diskStore)) continue;
            diskStoreDetails.add(new DiskStoreDetails.AsyncEventQueueDetails(queue.getId()));
        }
    }

    static {
        PERSISTENT_DATA_POLICIES.add(DataPolicy.PERSISTENT_PARTITION);
        PERSISTENT_DATA_POLICIES.add(DataPolicy.PERSISTENT_REPLICATE);
    }
}

