/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class CreateDefinedIndexesFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public String getId() {
        return CreateDefinedIndexesFunction.class.getName();
    }

    XmlEntity createXmlEntity(String regionName) {
        return new XmlEntity("region", "name", regionName);
    }

    public void execute(FunctionContext context) {
        String memberId = null;
        boolean lastResultSent = Boolean.FALSE;
        try {
            Cache cache = context.getCache();
            ResultSender sender = context.getResultSender();
            QueryService queryService = cache.getQueryService();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            Set indexDefinitions = (Set)context.getArguments();
            for (IndexInfo indexDefinition : indexDefinitions) {
                String indexName = indexDefinition.getIndexName();
                String regionPath = indexDefinition.getRegionPath();
                String indexedExpression = indexDefinition.getIndexedExpression();
                if (indexDefinition.getIndexType() == IndexType.PRIMARY_KEY) {
                    queryService.defineKeyIndex(indexName, indexedExpression, regionPath);
                    continue;
                }
                if (indexDefinition.getIndexType() == IndexType.HASH) {
                    queryService.defineHashIndex(indexName, indexedExpression, regionPath);
                    continue;
                }
                queryService.defineIndex(indexName, indexedExpression, regionPath);
            }
            List<Index> indexes = queryService.createDefinedIndexes();
            ArrayList<String> processedRegions = new ArrayList<String>();
            ArrayList<CliFunctionResult> functionResults = new ArrayList<CliFunctionResult>();
            for (Index index : indexes) {
                String regionName = index.getRegion().getName();
                if (processedRegions.contains(regionName)) continue;
                XmlEntity xmlEntity = this.createXmlEntity(regionName);
                functionResults.add(new CliFunctionResult(memberId, xmlEntity));
                processedRegions.add(regionName);
            }
            Iterator iterator = functionResults.iterator();
            while (iterator.hasNext()) {
                CliFunctionResult cliFunctionResult = (CliFunctionResult)iterator.next();
                if (iterator.hasNext()) {
                    sender.sendResult(cliFunctionResult);
                    continue;
                }
                sender.lastResult(cliFunctionResult);
                lastResultSent = Boolean.TRUE;
            }
            if (!lastResultSent) {
                sender.lastResult(new CliFunctionResult(memberId, true, "No indexes defined"));
            }
        }
        catch (MultiIndexCreationException multiIndexCreationException) {
            StringBuffer sb = new StringBuffer();
            sb.append("Index creation failed for indexes: ").append("\n");
            for (Map.Entry<String, Exception> failedIndex : multiIndexCreationException.getExceptionsMap().entrySet()) {
                sb.append(failedIndex.getKey()).append(" : ").append(failedIndex.getValue().getMessage()).append("\n");
            }
            context.getResultSender().lastResult(new CliFunctionResult(memberId, multiIndexCreationException, sb.toString()));
        }
        catch (Exception exception) {
            String exceptionMessage = CliStrings.format("Exception : {0} , Message : {1}", exception.getClass().getName(), exception.getMessage());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, exception, exceptionMessage));
        }
    }
}

