/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.Collection;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class ContinuousQueryFunction
implements Function,
InternalEntity {
    private static final long serialVersionUID = 1L;
    public static final String ID = ContinuousQueryFunction.class.getName();

    public void execute(FunctionContext context) {
        try {
            CacheClientNotifier cacheClientNotifier;
            AcceptorImpl acceptorImpl;
            CacheServerImpl server;
            String clientID = (String)context.getArguments();
            InternalCache cache = (InternalCache)context.getCache();
            if (cache.getCacheServers().size() > 0 && (server = (CacheServerImpl)cache.getCacheServers().iterator().next()) != null && (acceptorImpl = server.getAcceptor()) != null && (cacheClientNotifier = acceptorImpl.getCacheClientNotifier()) != null) {
                Collection<CacheClientProxy> cacheClientProxySet = cacheClientNotifier.getClientProxies();
                ClientInfo clientInfo = null;
                boolean foundClientinCCP = false;
                for (CacheClientProxy ccp : cacheClientProxySet) {
                    String clientIdFromProxy;
                    if (ccp == null || (clientIdFromProxy = ccp.getProxyID().getDSMembership()) == null || !clientIdFromProxy.equals(clientID)) continue;
                    foundClientinCCP = true;
                    String durableId = ccp.getProxyID().getDurableId();
                    boolean isPrimary = ccp.isPrimary();
                    clientInfo = new ClientInfo(durableId != null && durableId.length() > 0 ? "Yes" : "No", isPrimary ? cache.getDistributedSystem().getDistributedMember().getId() : "", !isPrimary ? cache.getDistributedSystem().getDistributedMember().getId() : "");
                    break;
                }
                if (!foundClientinCCP) {
                    ServerConnection[] serverConnections;
                    for (ServerConnection conn : serverConnections = acceptorImpl.getAllServerConnectionList()) {
                        ClientProxyMembershipID cliIdFrmProxy = conn.getProxyID();
                        if (!clientID.equals(cliIdFrmProxy.getDSMembership())) continue;
                        String durableId = cliIdFrmProxy.getDurableId();
                        clientInfo = new ClientInfo(durableId != null && durableId.length() > 0 ? "Yes" : "No", "N.A.", "N.A.");
                    }
                }
                context.getResultSender().lastResult(clientInfo);
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult("Exception in ContinuousQueryFunction =" + e.getMessage());
        }
        context.getResultSender().lastResult(null);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    public class ClientInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String isDurable;
        public String primaryServer;
        public String secondaryServer;

        public ClientInfo(String IsClientDurable, String primaryServerId, String secondaryServerId) {
            this.isDurable = IsClientDurable;
            this.primaryServer = primaryServerId;
            this.secondaryServer = secondaryServerId;
        }

        public String toString() {
            return "ClientInfo [isDurable=" + this.isDurable + ", primaryServer=" + this.primaryServer + ", secondaryServer=" + this.secondaryServer + "]";
        }
    }
}

