/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartVsdCommand
implements GfshCommand {
    @CliCommand(value={"start vsd"}, help="Start VSD in a separate process.")
    @CliMetaData(shellOnly=true, relatedTopic={"Management-Monitoring", "Statistics"})
    public Result startVsd(@CliOption(key={"file"}, help="File or directory from which to read the statistics archive(s).") String[] statisticsArchiveFilePathnames) {
        try {
            String geodeHome = System.getenv("GEODE_HOME");
            Assert.assertState(StringUtils.isNotBlank((String)geodeHome), "The GEODE environment variable was not defined.  Please set the GEODE environment variable to the directory where GEODE is installed.", new Object[0]);
            Assert.assertState(IOUtils.isExistingPathname(this.getPathToVsd()), String.format("The location of VSD could not be found.  Please ensure VSD was properly installed under Geode home (%1$s).", geodeHome), new Object[0]);
            Object[] vsdCommandLine = this.createdVsdCommandLine(statisticsArchiveFilePathnames);
            if (this.isDebugging()) {
                this.getGfsh().printAsInfo(String.format("GemFire VSD command-line (%1$s)", Arrays.toString(vsdCommandLine)));
            }
            Process vsdProcess = Runtime.getRuntime().exec((String[])vsdCommandLine);
            this.getGfsh().printAsInfo("Launched Geode Visual Statistics Display (VSD) (see Geode log files for issues on start)");
            String vsdProcessOutput = ProcessStreamReader.waitAndCaptureProcessStandardErrorStream(vsdProcess);
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            if (StringUtils.isNotBlank((String)vsdProcessOutput)) {
                infoResultData.addLine(StringUtils.LINE_SEPARATOR);
                infoResultData.addLine(vsdProcessOutput);
            }
            return ResultBuilder.buildResult(infoResultData);
        }
        catch (FileNotFoundException | IllegalArgumentException | IllegalStateException | GemFireException e) {
            return ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createShellClientErrorResult(String.format("An error occurred while launching VSD - %1$s", t.getMessage()));
        }
    }

    protected String[] createdVsdCommandLine(String[] statisticsArchiveFilePathnames) throws FileNotFoundException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getPathToVsd());
        commandLine.addAll(this.processStatisticsArchiveFiles(statisticsArchiveFilePathnames));
        return commandLine.toArray(new String[commandLine.size()]);
    }

    protected String getPathToVsd() {
        String vsdPathname = IOUtils.appendToPath(System.getenv("GEODE_HOME"), "tools", "vsd", "bin", "vsd");
        if (SystemUtils.isWindows()) {
            vsdPathname = vsdPathname + ".bat";
        }
        return vsdPathname;
    }

    protected Set<String> processStatisticsArchiveFiles(String[] statisticsArchiveFilePathnames) throws FileNotFoundException {
        TreeSet<String> statisticsArchiveFiles = new TreeSet<String>();
        if (statisticsArchiveFilePathnames != null) {
            for (String pathname : statisticsArchiveFilePathnames) {
                File path = new File(pathname);
                if (path.exists()) {
                    if (path.isFile()) {
                        if (StatisticsArchiveFileFilter.INSTANCE.accept(path)) {
                            statisticsArchiveFiles.add(pathname);
                            continue;
                        }
                        throw new IllegalArgumentException("A Statistics Archive File must end with a .gfs file extension.");
                    }
                    this.processStatisticsArchiveFiles(path, statisticsArchiveFiles);
                    continue;
                }
                throw new FileNotFoundException(String.format("The pathname (%1$s) does not exist.  Please check the path and try again.", path.getAbsolutePath()));
            }
        }
        return statisticsArchiveFiles;
    }

    protected void processStatisticsArchiveFiles(File path, Set<String> statisticsArchiveFiles) {
        if (path != null && path.isDirectory()) {
            for (File file : path.listFiles(StatisticsArchiveFileAndDirectoryFilter.INSTANCE)) {
                if (file.isDirectory()) {
                    this.processStatisticsArchiveFiles(file, statisticsArchiveFiles);
                    continue;
                }
                if (!StatisticsArchiveFileFilter.INSTANCE.accept(file)) continue;
                statisticsArchiveFiles.add(file.getAbsolutePath());
            }
        }
    }

    protected static class StatisticsArchiveFileAndDirectoryFilter
    extends StatisticsArchiveFileFilter {
        protected static final StatisticsArchiveFileAndDirectoryFilter INSTANCE = new StatisticsArchiveFileAndDirectoryFilter();

        protected StatisticsArchiveFileAndDirectoryFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || super.accept(pathname);
        }
    }

    protected static class StatisticsArchiveFileFilter
    implements FileFilter {
        protected static final StatisticsArchiveFileFilter INSTANCE = new StatisticsArchiveFileFilter();

        protected StatisticsArchiveFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getAbsolutePath().endsWith(".gfs");
        }
    }
}

