/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.FetchSharedConfigurationStatusFunction;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class StatusClusterConfigServiceCommand
implements GfshCommand {
    private static final FetchSharedConfigurationStatusFunction fetchSharedConfigStatusFunction = new FetchSharedConfigurationStatusFunction();

    @CliCommand(value={"status cluster-config-service"}, help="Displays the status of cluster configuration service on all the locators with enable-cluster-configuration set to true.")
    @CliMetaData(relatedTopic={"Locator"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result statusSharedConfiguration() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        HashSet<DistributedMember> locators = new HashSet<DistributedMember>(cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        if (locators.isEmpty()) {
            return ResultBuilder.createInfoResult("No locators found with \"enable-cluster-configuration=true\".");
        }
        return ResultBuilder.buildResult(this.getSharedConfigurationStatus(locators));
    }

    private TabularResultData getSharedConfigurationStatus(Set<DistributedMember> locators) {
        boolean isSharedConfigRunning = false;
        ResultCollector<?, ?> rc = CliUtil.executeFunction(fetchSharedConfigStatusFunction, null, locators);
        List results = (List)rc.getResult();
        TabularResultData table = ResultBuilder.createTabularResultData();
        table.setHeader("Status of shared configuration on locators");
        for (CliFunctionResult result : results) {
            table.accumulate("Name", result.getMemberIdOrName());
            String status = (String)((Object)result.getSerializables()[0]);
            table.accumulate("Status", status);
            if (!SharedConfigurationStatus.RUNNING.name().equals(status)) continue;
            isSharedConfigRunning = true;
        }
        if (!isSharedConfigRunning) {
            table.setStatus(Result.Status.ERROR);
        }
        return table;
    }
}

