/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.process.ProcessType;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.LauncherSignalListener;
import org.apache.geode.management.internal.cli.commands.StartMemberUtils;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartServerCommand
implements GfshCommand {
    private static final String SERVER_TERM_NAME = "Server";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"start server"}, help="Start a Geode Cache Server.")
    @CliMetaData(shellOnly=true, relatedTopic={"Server", "Lifecycle"})
    public Result startServer(@CliOption(key={"name"}, help="The member name to give this Cache Server in the Geode cluster.") String memberName, @CliOption(key={"assign-buckets"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to assign buckets to the partitioned regions of the cache on server start.") Boolean assignBuckets, @CliOption(key={"bind-address"}, help="The IP address on which the Server will be bound.  By default, the Server is bound to all local addresses.") String bindAddress, @CliOption(key={"cache-xml-file"}, optionContext="geode.converter.file.path:disable-string-converter", help="Specifies the name of the XML file or resource to initialize the cache with when it is created.") String cacheXmlPathname, @CliOption(key={"classpath"}, help="Location of user application classes required by the Server. The user classpath is prepended to the Server's classpath.") String classpath, @CliOption(key={"critical-heap-percentage"}, help="Set the percentage of heap at or above which the cache is considered in danger of becoming inoperable due to garbage collection pauses or out of memory exceptions") Float criticalHeapPercentage, @CliOption(key={"critical-off-heap-percentage"}, help="Set the percentage of off-heap memory at or above which the cache is considered in danger of becoming inoperable due to out of memory exceptions") Float criticalOffHeapPercentage, @CliOption(key={"dir"}, help="Directory in which the Cache Server will be started and ran. The default is ./<server-member-name>") String workingDirectory, @CliOption(key={"disable-default-server"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether the Cache Server will be started by default.") Boolean disableDefaultServer, @CliOption(key={"disable-exit-when-out-of-memory"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Prevents the JVM from exiting when an OutOfMemoryError occurs.") Boolean disableExitWhenOutOfMemory, @CliOption(key={"enable-time-statistics"}, specifiedDefaultValue="true", help="Causes additional time-based statistics to be gathered for Geode operations.") Boolean enableTimeStatistics, @CliOption(key={"eviction-heap-percentage"}, help="Set the percentage of heap at or above which the eviction should begin on Regions configured for HeapLRU eviction. Changing this value may cause eviction to begin immediately.Only one change to this attribute or critical heap percentage will be allowed at any given time and its effect will be fully realized before the next change is allowed. This feature requires additional VM flags to perform properly. ") Float evictionHeapPercentage, @CliOption(key={"eviction-off-heap-percentage"}, help="Set the percentage of off-heap memory at or above which the eviction should begin on Regions configured for off-heap and HeapLRU eviction. Changing this value may cause eviction to begin immediately. Only one change to this attribute or critical off-heap percentage will be allowed at any given time and its effect will be fully realized before the next change is allowed.") Float evictionOffHeapPercentage, @CliOption(key={"force"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to allow the PID file from a previous Cache Server run to be overwritten.") Boolean force, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) the Cache Server will be a part of.") String group, @CliOption(key={"hostname-for-clients"}, help="Sets the ip address or host name that this cache server is to listen on for client connections.Setting a specific hostname-for-clients will cause server locators to use this value when telling clients how to connect to this cache server. This is useful in the case where the cache server may refer to itself with one hostname, but the clients need to use a different hostname to find the cache server.The value \"\" causes the bind-address to be given to clients.A null value will be treated the same as the default \"\".") String hostNameForClients, @CliOption(key={"jmx-manager-hostname-for-clients"}, help="Hostname provided to clients by the server for the location of a JMX Manager.") String jmxManagerHostnameForClients, @CliOption(key={"include-system-classpath"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Includes the System CLASSPATH on the Server's CLASSPATH. The System CLASSPATH is not included by default.") Boolean includeSystemClasspath, @CliOption(key={"initial-heap"}, help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Argument passed to the JVM on which the server will run. For example, --J=-Dfoo.bar=true will set the system property \"foo.bar\" to \"true\".") String[] jvmArgsOpts, @CliOption(key={"locators"}, optionContext="geode.converter.locators.discovery.config:disable-string-converter", help="Sets the list of Locators used by the Cache Server to join the appropriate Geode cluster.") String locators, @CliOption(key={"locator-wait-time"}, help="Sets the number of seconds the server will wait for a locator to become available during startup before giving up.") Integer locatorWaitTime, @CliOption(key={"lock-memory"}, specifiedDefaultValue="true", help="Causes Geode to lock heap and off-heap memory pages into RAM. This prevents the operating system from swapping the pages out to disk, which can cause severe performance degradation. When you use this option, also configure the operating system limits for locked memory.") Boolean lockMemory, @CliOption(key={"log-level"}, optionContext="geode.converter.log.levels:disable-string-converter", help="Sets the level of output logged to the Cache Server log file.  Possible values for log-level include: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF.") String logLevel, @CliOption(key={"max-connections"}, help="Sets the maximum number of client connections allowed. When the maximum is reached the cache server will stop accepting connections") Integer maxConnections, @CliOption(key={"max-heap"}, help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"max-message-count"}, help="Sets maximum number of messages that can be enqueued in a client-queue.") Integer maxMessageCount, @CliOption(key={"max-threads"}, help="Sets the maximum number of threads allowed in this cache server to service client requests. The default of 0 causes the cache server to dedicate a thread for every client connection") Integer maxThreads, @CliOption(key={"mcast-address"}, help="The IP address or hostname used to bind the UPD socket for multi-cast networking so the Cache Server can communicate with other members in the Geode cluster.  If mcast-port is zero, then mcast-address is ignored.") String mcastBindAddress, @CliOption(key={"mcast-port"}, help="Sets the port used for multi-cast networking so the Cache Server can communicate with other members of the Geode cluster.  A zero value disables mcast.") Integer mcastPort, @CliOption(key={"memcached-port"}, help="Sets the port that the Geode memcached service listens on for memcached clients.") Integer memcachedPort, @CliOption(key={"memcached-protocol"}, help="Sets the protocol that the Geode memcached service uses (ASCII or BINARY).") String memcachedProtocol, @CliOption(key={"memcached-bind-address"}, help="Sets the IP address the Geode memcached service listens on for memcached clients. The default is to bind to the first non-loopback address for this machine.") String memcachedBindAddress, @CliOption(key={"redis-port"}, help="Sets the port that the Geode Redis service listens on for Redis clients.") Integer redisPort, @CliOption(key={"redis-bind-address"}, help="Sets the IP address the Geode Redis service listens on for Redis clients. The default is to bind to the first non-loopback address for this machine.") String redisBindAddress, @CliOption(key={"redis-password"}, help="Sets the authentication password for GeodeRedisServer") String redisPassword, @CliOption(key={"message-time-to-live"}, help="Sets the time (in seconds ) after which a message in the client queue will expire") Integer messageTimeToLive, @CliOption(key={"off-heap-memory-size"}, help="The total size of off-heap memory specified as off-heap-memory-size=<n>[g|m]. <n> is the size. [g|m] indicates whether the size should be interpreted as gigabytes or megabytes. A non-zero size causes that much memory to be allocated from the operating system and reserved for off-heap use.") String offHeapMemorySize, @CliOption(key={"properties-file"}, optionContext="geode.converter.file", help="The gemfire.properties file for configuring the Cache Server's distributed system. The file's path can be absolute or relative to the gfsh working directory.") File gemfirePropertiesFile, @CliOption(key={"rebalance"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to initiate rebalancing across the Geode cluster.") Boolean rebalance, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file", help="The gfsecurity.properties file for configuring the Server's security configuration in the distributed system. The file's path can be absolute or relative to gfsh directory.") File gemfireSecurityPropertiesFile, @CliOption(key={"server-bind-address"}, unspecifiedDefaultValue="", help="The IP address that this distributed system's server sockets in a client-server topology will be bound. If set to an empty string then all of the local machine's addresses will be listened on.") String serverBindAddress, @CliOption(key={"server-port"}, unspecifiedDefaultValue="40404", help="The port that the distributed system's server sockets in a client-server topology will listen on.  The default server-port is 40404.") Integer serverPort, @CliOption(key={"socket-buffer-size"}, help="Sets the buffer size in bytes of the socket connection for this CacheServer. The default is 32768 bytes.") Integer socketBufferSize, @CliOption(key={"spring-xml-location"}, help="Specifies the location of a Spring XML configuration file(s) for bootstrapping and configuring a Geode Server.") String springXmlLocation, @CliOption(key={"statistic-archive-file"}, help="The file that statistic samples are written to.  An empty string (default) disables statistic archival.") String statisticsArchivePathname, @CliOption(key={"use-cluster-configuration"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When set to true, the server requests the configuration from locator's cluster configuration service.") Boolean requestSharedConfiguration, @CliOption(key={"start-rest-api"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="When set to true, will start the REST API service.") Boolean startRestApi, @CliOption(key={"http-service-port"}, unspecifiedDefaultValue="", help="Port on which HTTP Service will listen on") String httpServicePort, @CliOption(key={"http-service-bind-address"}, unspecifiedDefaultValue="", help="The IP address on which the HTTP Service will be bound.  By default, the Server is bound to all local addresses.") String httpServiceBindAddress, @CliOption(key={"user"}, unspecifiedDefaultValue="", help="User name to securely connect to the cluster. If the --password parameter is not specified then it will be prompted for.") String userName, @CliOption(key={"password"}, unspecifiedDefaultValue="", help="Password to securely connect to the cluster.") String passwordToUse) throws Exception {
        ServerLauncher.ServerState serverState;
        if (StringUtils.isBlank((String)memberName)) {
            memberName = StartMemberUtils.getNameGenerator().generate('-');
        }
        if (StringUtils.isNotBlank((String)userName)) {
            if (StringUtils.isBlank((String)passwordToUse)) {
                passwordToUse = this.getGfsh().readPassword("password: ");
            }
            if (StringUtils.isBlank((String)passwordToUse)) {
                return ResultBuilder.createConnectionErrorResult("password must be specified.");
            }
        }
        workingDirectory = StartMemberUtils.resolveWorkingDir(workingDirectory, memberName);
        if (StringUtils.isNotBlank((String)(cacheXmlPathname = CliUtil.resolvePathname(cacheXmlPathname))) && !IOUtils.isExistingPathname(cacheXmlPathname)) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode cache XML file {0} could not be found.", (Object)cacheXmlPathname));
        }
        if (gemfirePropertiesFile != null && !gemfirePropertiesFile.exists()) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "", gemfirePropertiesFile.getAbsolutePath()));
        }
        if (gemfireSecurityPropertiesFile != null && !gemfireSecurityPropertiesFile.exists()) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "Security ", gemfireSecurityPropertiesFile.getAbsolutePath()));
        }
        File serverPidFile = new File(workingDirectory, ProcessType.SERVER.getPidFileName());
        int oldPid = StartMemberUtils.readPid(serverPidFile);
        Properties gemfireProperties = new Properties();
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "bind-address", bindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "cache-xml-file", cacheXmlPathname);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "enable-time-statistics", enableTimeStatistics);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "groups", group);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "jmx-manager-hostname-for-clients", jmxManagerHostnameForClients);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "locators", locators);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "locator-wait-time", locatorWaitTime);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "log-level", logLevel);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "mcast-address", mcastBindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "mcast-port", mcastPort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "memcached-port", memcachedPort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "memcached-protocol", memcachedProtocol);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "memcached-bind-address", memcachedBindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "redis-port", redisPort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "redis-bind-address", redisBindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "redis-password", redisPassword);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "statistic-archive-file", statisticsArchivePathname);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "use-cluster-configuration", requestSharedConfiguration);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "lock-memory", lockMemory);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "off-heap-memory-size", offHeapMemorySize);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "start-dev-rest-api", startRestApi);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "http-service-port", httpServicePort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "http-service-bind-address", httpServiceBindAddress);
        if (StringUtils.isNotBlank((String)userName)) {
            gemfireProperties.setProperty("security-username", userName);
            gemfireProperties.setProperty("security-password", passwordToUse);
        }
        boolean redirectOutput = Boolean.getBoolean("gemfire.OSProcess.ENABLE_OUTPUT_REDIRECTION");
        ServerLauncher.Builder serverLauncherBuilder = new ServerLauncher.Builder().setAssignBuckets(assignBuckets).setDisableDefaultServer(disableDefaultServer).setForce(force).setRebalance(rebalance).setRedirectOutput(redirectOutput).setServerBindAddress(serverBindAddress).setServerPort(serverPort).setSpringXmlLocation(springXmlLocation).setWorkingDirectory(workingDirectory).setCriticalHeapPercentage(criticalHeapPercentage).setEvictionHeapPercentage(evictionHeapPercentage).setCriticalOffHeapPercentage(criticalOffHeapPercentage).setEvictionOffHeapPercentage(evictionOffHeapPercentage).setMaxConnections(maxConnections).setMaxMessageCount(maxMessageCount).setMaxThreads(maxThreads).setMessageTimeToLive(messageTimeToLive).setSocketBufferSize(socketBufferSize);
        if (hostNameForClients != null) {
            serverLauncherBuilder.setHostNameForClients(hostNameForClients);
        }
        if (memberName != null) {
            serverLauncherBuilder.setMemberName(memberName);
        }
        ServerLauncher serverLauncher = serverLauncherBuilder.build();
        Object[] serverCommandLine = this.createStartServerCommandLine(serverLauncher, gemfirePropertiesFile, gemfireSecurityPropertiesFile, gemfireProperties, classpath, includeSystemClasspath, jvmArgsOpts, disableExitWhenOutOfMemory, initialHeap, maxHeap);
        if (this.getGfsh().getDebug()) {
            this.getGfsh().logInfo(StringUtils.join((Object[])serverCommandLine, (String)" "), null);
        }
        Process serverProcess = new ProcessBuilder((String[])serverCommandLine).directory(new File(serverLauncher.getWorkingDirectory())).start();
        serverProcess.getInputStream().close();
        serverProcess.getOutputStream().close();
        ProcessStreamReader.ReadingMode readingMode = SystemUtils.isWindows() ? ProcessStreamReader.ReadingMode.NON_BLOCKING : ProcessStreamReader.ReadingMode.BLOCKING;
        StringBuffer message = new StringBuffer();
        ProcessStreamReader.InputListener inputListener = line -> {
            message.append(line);
            if (readingMode == ProcessStreamReader.ReadingMode.BLOCKING) {
                message.append(StringUtils.LINE_SEPARATOR);
            }
        };
        ProcessStreamReader stderrReader = new ProcessStreamReader.Builder(serverProcess).inputStream(serverProcess.getErrorStream()).inputListener(inputListener).readingMode(readingMode).continueReadingMillis(2000L).build().start();
        String previousServerStatusMessage = null;
        LauncherSignalListener serverSignalListener = new LauncherSignalListener();
        boolean registeredServerSignalListener = this.getGfsh().getSignalHandler().registerListener(serverSignalListener);
        try {
            this.getGfsh().logInfo(String.format("Starting a Geode Server in %1$s...", IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(serverLauncher.getWorkingDirectory()))), null);
            serverState = ServerLauncher.ServerState.fromDirectory(workingDirectory, memberName);
            do {
                if (serverProcess.isAlive()) {
                    Gfsh.print(".");
                    StartServerCommand startServerCommand = this;
                    synchronized (startServerCommand) {
                        TimeUnit.MILLISECONDS.timedWait(this, 500L);
                    }
                    serverState = ServerLauncher.ServerState.fromDirectory(workingDirectory, memberName);
                    String currentServerStatusMessage = serverState.getStatusMessage();
                    if (!serverState.isStartingOrNotResponding() || StringUtils.isBlank((String)currentServerStatusMessage) || currentServerStatusMessage.equalsIgnoreCase(previousServerStatusMessage) || currentServerStatusMessage.trim().toLowerCase().equals("null")) continue;
                    Gfsh.println();
                    Gfsh.println(currentServerStatusMessage);
                    previousServerStatusMessage = currentServerStatusMessage;
                    continue;
                }
                int exitValue = serverProcess.exitValue();
                CommandResult commandResult = ResultBuilder.createShellClientErrorResult(String.format("The Cache Server process terminated unexpectedly with exit status %1$d. Please refer to the log file in %2$s for full details.%n%n%3$s", exitValue, serverLauncher.getWorkingDirectory(), message.toString()));
                return commandResult;
            } while ((!registeredServerSignalListener || !serverSignalListener.isSignaled()) && serverState.isStartingOrNotResponding());
        }
        finally {
            stderrReader.stopAsync(5000L);
            this.getGfsh().getSignalHandler().unregisterListener(serverSignalListener);
        }
        Gfsh.println();
        boolean asyncStart = ServerLauncher.ServerState.isStartingNotRespondingOrNull(serverState);
        if (asyncStart) {
            Gfsh.print(String.format("Broken out of wait... the %1$s process will continue to startup in the background.%n", SERVER_TERM_NAME));
            return ResultBuilder.createInfoResult("");
        }
        return ResultBuilder.createInfoResult(serverState.toString());
    }

    String[] createStartServerCommandLine(ServerLauncher launcher, File gemfirePropertiesFile, File gemfireSecurityPropertiesFile, Properties gemfireProperties, String userClasspath, Boolean includeSystemClasspath, String[] jvmArgsOpts, Boolean disableExitWhenOutOfMemory, String initialHeap, String maxHeap) throws MalformedObjectNameException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(StartMemberUtils.getJavaPath());
        commandLine.add("-server");
        commandLine.add("-classpath");
        commandLine.add(this.getServerClasspath(Boolean.TRUE.equals(includeSystemClasspath), userClasspath));
        StartMemberUtils.addCurrentLocators(this, commandLine, gemfireProperties);
        StartMemberUtils.addGemFirePropertyFile(commandLine, gemfirePropertiesFile);
        StartMemberUtils.addGemFireSecurityPropertyFile(commandLine, gemfireSecurityPropertiesFile);
        StartMemberUtils.addGemFireSystemProperties(commandLine, gemfireProperties);
        StartMemberUtils.addJvmArgumentsAndOptions(commandLine, jvmArgsOpts);
        if (!Boolean.TRUE.equals(disableExitWhenOutOfMemory)) {
            this.addJvmOptionsForOutOfMemoryErrors(commandLine);
        }
        StartMemberUtils.addInitialHeap(commandLine, initialHeap);
        StartMemberUtils.addMaxHeap(commandLine, maxHeap);
        commandLine.add("-D".concat("gemfire.launcher.registerSignalHandlers".concat("=true")));
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dsun.rmi.dgc.server.gcInterval".concat("=").concat(Long.toString(0x7FFFFFFFFFFFFFFEL)));
        commandLine.add(ServerLauncher.class.getName());
        commandLine.add(ServerLauncher.Command.START.getName());
        if (StringUtils.isNotBlank((String)launcher.getMemberName())) {
            commandLine.add(launcher.getMemberName());
        }
        if (launcher.isAssignBuckets()) {
            commandLine.add("--assign-buckets");
        }
        if (launcher.isDebugging() || this.isDebugging()) {
            commandLine.add("--debug");
        }
        if (launcher.isDisableDefaultServer()) {
            commandLine.add("--disable-default-server");
        }
        if (launcher.isForcing()) {
            commandLine.add("--force");
        }
        if (launcher.isRebalancing()) {
            commandLine.add("--rebalance");
        }
        if (launcher.isRedirectingOutput()) {
            commandLine.add("--redirect-output");
        }
        if (launcher.getServerBindAddress() != null) {
            commandLine.add("--server-bind-address=" + launcher.getServerBindAddress().getCanonicalHostName());
        }
        if (launcher.getServerPort() != null) {
            commandLine.add("--server-port=" + launcher.getServerPort());
        }
        if (launcher.isSpringXmlLocationSpecified()) {
            commandLine.add("--spring-xml-location=".concat(launcher.getSpringXmlLocation()));
        }
        if (launcher.getCriticalHeapPercentage() != null) {
            commandLine.add("--critical-heap-percentage=" + launcher.getCriticalHeapPercentage());
        }
        if (launcher.getEvictionHeapPercentage() != null) {
            commandLine.add("--eviction-heap-percentage=" + launcher.getEvictionHeapPercentage());
        }
        if (launcher.getCriticalOffHeapPercentage() != null) {
            commandLine.add("--critical-off-heap-percentage=" + launcher.getCriticalOffHeapPercentage());
        }
        if (launcher.getEvictionOffHeapPercentage() != null) {
            commandLine.add("--eviction-off-heap-percentage=" + launcher.getEvictionOffHeapPercentage());
        }
        if (launcher.getMaxConnections() != null) {
            commandLine.add("--max-connections=" + launcher.getMaxConnections());
        }
        if (launcher.getMaxMessageCount() != null) {
            commandLine.add("--max-message-count=" + launcher.getMaxMessageCount());
        }
        if (launcher.getMaxThreads() != null) {
            commandLine.add("--max-threads=" + launcher.getMaxThreads());
        }
        if (launcher.getMessageTimeToLive() != null) {
            commandLine.add("--message-time-to-live=" + launcher.getMessageTimeToLive());
        }
        if (launcher.getSocketBufferSize() != null) {
            commandLine.add("--socket-buffer-size=" + launcher.getSocketBufferSize());
        }
        if (launcher.getHostNameForClients() != null) {
            commandLine.add("--hostname-for-clients=" + launcher.getHostNameForClients());
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    String getServerClasspath(boolean includeSystemClasspath, String userClasspath) {
        ArrayList<String> jarFilePathnames = new ArrayList<String>();
        jarFilePathnames.add(StartMemberUtils.CORE_DEPENDENCIES_JAR_PATHNAME);
        return StartMemberUtils.toClasspath(includeSystemClasspath, jarFilePathnames.toArray(new String[jarFilePathnames.size()]), userClasspath);
    }

    private void addJvmOptionsForOutOfMemoryErrors(List<String> commandLine) {
        if (SystemUtils.isHotSpotVM()) {
            if (SystemUtils.isWindows()) {
                commandLine.add("-XX:OnOutOfMemoryError=taskkill /F /PID %p");
            } else {
                commandLine.add("-XX:OnOutOfMemoryError=kill -KILL %p");
            }
        } else if (SystemUtils.isJ9VM()) {
            commandLine.add("-Xcheck:memory");
        } else if (SystemUtils.isJRockitVM()) {
            commandLine.add("-XXexitOnOutOfMemory");
        }
    }
}

