/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.net.ssl.SSLException;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.process.ProcessStreamReader;
import org.apache.geode.internal.process.ProcessType;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.ConnectCommand;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.LauncherSignalListener;
import org.apache.geode.management.internal.cli.commands.StartMemberUtils;
import org.apache.geode.management.internal.cli.domain.ConnectToLocatorResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.JmxOperationInvoker;
import org.apache.geode.management.internal.cli.util.CauseFinder;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.cli.util.ConnectionEndpoint;
import org.apache.geode.management.internal.cli.util.HostUtils;
import org.apache.geode.management.internal.configuration.utils.ClusterConfigurationStatusRetriever;
import org.apache.geode.security.AuthenticationFailedException;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartLocatorCommand
implements GfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"start locator"}, help="Start a Locator.")
    @CliMetaData(shellOnly=true, relatedTopic={"Locator", "Lifecycle"})
    public Result startLocator(@CliOption(key={"name"}, help="The member name to give this Locator in the Geode cluster.") String memberName, @CliOption(key={"bind-address"}, help="IP address on which the Locator will be bound.  By default, the Locator is bound to all local addresses.") String bindAddress, @CliOption(key={"classpath"}, help="Location of user application classes required by the Locator. The user classpath is prepended to the Locator's classpath.") String classpath, @CliOption(key={"force"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to allow the PID file from a previous Locator run to be overwritten.") Boolean force, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) the Locator will be a part of.") String group, @CliOption(key={"hostname-for-clients"}, help="Hostname or IP address that will be sent to clients so they can connect to this Locator. The default is the bind-address of the Locator.") String hostnameForClients, @CliOption(key={"jmx-manager-hostname-for-clients"}, help="Hostname provided to clients by the locator for the location of a JMX Manager.") String jmxManagerHostnameForClients, @CliOption(key={"include-system-classpath"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Includes the System CLASSPATH on the Locator's CLASSPATH. The System CLASSPATH is not included by default.") Boolean includeSystemClasspath, @CliOption(key={"locators"}, optionContext="geode.converter.locators.discovery.config:disable-string-converter", help="Sets the list of Locators used by this Locator to join the appropriate Geode cluster.") String locators, @CliOption(key={"log-level"}, optionContext="geode.converter.log.levels:disable-string-converter", help="Sets the level of output logged to the Locator log file.  Possible values for log-level include: ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, OFF.") String logLevel, @CliOption(key={"mcast-address"}, help="The IP address or hostname used to bind the UPD socket for multi-cast networking so the Locator can communicate with other members in the Geode cluster using a common multicast address and port.  If mcast-port is zero, then mcast-address is ignored.") String mcastBindAddress, @CliOption(key={"mcast-port"}, help="Sets the port used for multi-cast networking so the Locator can communicate with other members of the Geode cluster.  A zero value disables mcast.") Integer mcastPort, @CliOption(key={"port"}, help="Port the Locator will listen on.") Integer port, @CliOption(key={"dir"}, help="Directory in which the Locator will be started and ran. The default is ./<locator-member-name>") String workingDirectory, @CliOption(key={"properties-file"}, optionContext="geode.converter.file", help="The gemfire.properties file for configuring the Locator's distributed system. The file's path can be absolute or relative to the gfsh working directory (--dir=).") File gemfirePropertiesFile, @CliOption(key={"security-properties-file"}, optionContext="geode.converter.file", help="The gfsecurity.properties file for configuring the Locator's security configuration in the distributed system. The file's path can be absolute or relative to gfsh directory (--dir=).") File gemfireSecurityPropertiesFile, @CliOption(key={"initial-heap"}, help="Initial size of the heap in the same format as the JVM -Xms parameter.") String initialHeap, @CliOption(key={"max-heap"}, help="Maximum size of the heap in the same format as the JVM -Xmx parameter.") String maxHeap, @CliOption(key={"J"}, optionContext="splittingRegex=\u001f", help="Argument passed to the JVM on which the Locator will run. For example, --J=-Dfoo.bar=true will set the property \"foo.bar\" to \"true\".") String[] jvmArgsOpts, @CliOption(key={"connect"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When connect is set to false , Gfsh does not automatically connect to the locator which is started using this command.") boolean connect, @CliOption(key={"enable-cluster-configuration"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="When enable-cluster-configuration is set to true, locator hosts and serves cluster configuration.") boolean enableSharedConfiguration, @CliOption(key={"load-cluster-configuration-from-dir"}, unspecifiedDefaultValue="false", help="When \" load-cluster-configuration-from-dir \" is set to true, the locator loads the cluster configuration from the \"cluster_config\" directory.") boolean loadSharedConfigurationFromDirectory, @CliOption(key={"cluster-config-dir"}, unspecifiedDefaultValue="", help="Directory used by the cluster configuration service to store the cluster configuration on the filesystem") String clusterConfigDir, @CliOption(key={"http-service-port"}, help="Port on which HTTP Service will listen on") Integer httpServicePort, @CliOption(key={"http-service-bind-address"}, help="The IP address on which the HTTP Service will be bound.  By default, the Server is bound to all local addresses.") String httpServiceBindAddress) throws Exception {
        LocatorLauncher.LocatorState locatorState;
        if (StringUtils.isBlank((String)memberName)) {
            memberName = StartMemberUtils.getNameGenerator().generate('-');
        }
        workingDirectory = StartMemberUtils.resolveWorkingDir(workingDirectory, memberName);
        if (gemfirePropertiesFile != null && !gemfirePropertiesFile.exists()) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "", gemfirePropertiesFile.getAbsolutePath()));
        }
        if (gemfireSecurityPropertiesFile != null && !gemfireSecurityPropertiesFile.exists()) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Warning: The Geode {0}properties file {1} could not be found.", "Security ", gemfireSecurityPropertiesFile.getAbsolutePath()));
        }
        File locatorPidFile = new File(workingDirectory, ProcessType.LOCATOR.getPidFileName());
        int oldPid = StartMemberUtils.readPid(locatorPidFile);
        Properties gemfireProperties = new Properties();
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "groups", group);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "locators", locators);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "log-level", logLevel);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "mcast-address", mcastBindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "mcast-port", mcastPort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "enable-cluster-configuration", enableSharedConfiguration);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "load-cluster-configuration-from-dir", loadSharedConfigurationFromDirectory);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "cluster-configuration-dir", clusterConfigDir);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "http-service-port", httpServicePort);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "http-service-bind-address", httpServiceBindAddress);
        StartMemberUtils.setPropertyIfNotNull(gemfireProperties, "jmx-manager-hostname-for-clients", jmxManagerHostnameForClients);
        boolean redirectOutput = Boolean.getBoolean("gemfire.OSProcess.ENABLE_OUTPUT_REDIRECTION");
        LocatorLauncher.Builder locatorLauncherBuilder = new LocatorLauncher.Builder().setBindAddress(bindAddress).setForce(force).setPort(port).setRedirectOutput(redirectOutput).setWorkingDirectory(workingDirectory);
        if (hostnameForClients != null) {
            locatorLauncherBuilder.setHostnameForClients(hostnameForClients);
        }
        if (memberName != null) {
            locatorLauncherBuilder.setMemberName(memberName);
        }
        LocatorLauncher locatorLauncher = locatorLauncherBuilder.build();
        String[] locatorCommandLine = this.createStartLocatorCommandLine(locatorLauncher, gemfirePropertiesFile, gemfireSecurityPropertiesFile, gemfireProperties, classpath, includeSystemClasspath, jvmArgsOpts, initialHeap, maxHeap);
        Process locatorProcess = new ProcessBuilder(locatorCommandLine).directory(new File(locatorLauncher.getWorkingDirectory())).start();
        locatorProcess.getInputStream().close();
        locatorProcess.getOutputStream().close();
        ProcessStreamReader.ReadingMode readingMode = SystemUtils.isWindows() ? ProcessStreamReader.ReadingMode.NON_BLOCKING : ProcessStreamReader.ReadingMode.BLOCKING;
        StringBuffer message = new StringBuffer();
        ProcessStreamReader.InputListener inputListener = line -> {
            message.append(line);
            if (readingMode == ProcessStreamReader.ReadingMode.BLOCKING) {
                message.append(StringUtils.LINE_SEPARATOR);
            }
        };
        ProcessStreamReader stderrReader = new ProcessStreamReader.Builder(locatorProcess).inputStream(locatorProcess.getErrorStream()).inputListener(inputListener).readingMode(readingMode).continueReadingMillis(2000L).build().start();
        String previousLocatorStatusMessage = null;
        LauncherSignalListener locatorSignalListener = new LauncherSignalListener();
        boolean registeredLocatorSignalListener = this.getGfsh().getSignalHandler().registerListener(locatorSignalListener);
        try {
            this.getGfsh().logInfo(String.format("Starting a Geode Locator in %1$s...", IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(locatorLauncher.getWorkingDirectory()))), null);
            do {
                if (locatorProcess.isAlive()) {
                    Gfsh.print(".");
                    StartLocatorCommand startLocatorCommand = this;
                    synchronized (startLocatorCommand) {
                        TimeUnit.MILLISECONDS.timedWait(this, 500L);
                    }
                    locatorState = LocatorLauncher.LocatorState.fromDirectory(workingDirectory, memberName);
                    String currentLocatorStatusMessage = locatorState.getStatusMessage();
                    if (!locatorState.isStartingOrNotResponding() || StringUtils.isBlank((String)currentLocatorStatusMessage) || currentLocatorStatusMessage.equalsIgnoreCase(previousLocatorStatusMessage) || currentLocatorStatusMessage.trim().toLowerCase().equals("null")) continue;
                    Gfsh.println();
                    Gfsh.println(currentLocatorStatusMessage);
                    previousLocatorStatusMessage = currentLocatorStatusMessage;
                    continue;
                }
                int exitValue = locatorProcess.exitValue();
                CommandResult commandResult = ResultBuilder.createShellClientErrorResult(String.format("The Locator process terminated unexpectedly with exit status %1$d. Please refer to the log file in %2$s for full details.%n%n%3$s", exitValue, locatorLauncher.getWorkingDirectory(), message.toString()));
                return commandResult;
            } while ((!registeredLocatorSignalListener || !locatorSignalListener.isSignaled()) && locatorState.isStartingOrNotResponding());
        }
        finally {
            stderrReader.stopAsync(5000L);
            this.getGfsh().getSignalHandler().unregisterListener(locatorSignalListener);
        }
        Gfsh.println();
        boolean asyncStart = registeredLocatorSignalListener && locatorSignalListener.isSignaled() && ServerLauncher.ServerState.isStartingNotRespondingOrNull(locatorState);
        InfoResultData infoResultData = ResultBuilder.createInfoResultData();
        if (asyncStart) {
            infoResultData.addLine(String.format("Broken out of wait... the %1$s process will continue to startup in the background.%n", "Locator"));
            return ResultBuilder.buildResult(infoResultData);
        }
        infoResultData.addLine(locatorState.toString());
        InetAddress bindAddr = locatorLauncher.getBindAddress();
        String locatorHostName = bindAddr != null ? bindAddr.getCanonicalHostName() : StringUtils.defaultIfBlank((String)locatorLauncher.getHostnameForClients(), (String)HostUtils.getLocalHost());
        int locatorPort = Integer.parseInt(locatorState.getPort());
        ConnectCommand connectCommand = new ConnectCommand();
        Properties configProperties = connectCommand.resolveSslProperties(this.getGfsh(), false, gemfirePropertiesFile, gemfireSecurityPropertiesFile, new String[0]);
        if (this.shouldAutoConnect(connect)) {
            this.doAutoConnect(locatorHostName, locatorPort, configProperties, infoResultData);
        }
        if (enableSharedConfiguration) {
            infoResultData.addLine(ClusterConfigurationStatusRetriever.fromLocator(locatorHostName, locatorPort, configProperties));
        }
        return ResultBuilder.buildResult(infoResultData);
    }

    private boolean shouldAutoConnect(boolean connect) {
        return connect && !this.isConnectedAndReady();
    }

    private void doAutoConnect(String locatorHostname, int locatorPort, Properties configurationProperties, InfoResultData infoResultData) {
        boolean connectSuccess = false;
        boolean jmxManagerAuthEnabled = false;
        boolean jmxManagerSslEnabled = false;
        String responseFailureMessage = null;
        for (int attempts = 0; attempts < 10 && !connectSuccess; ++attempts) {
            try {
                ConnectToLocatorResult connectToLocatorResult = ConnectCommand.connectToLocator(locatorHostname, locatorPort, 15000, configurationProperties);
                ConnectionEndpoint memberEndpoint = connectToLocatorResult.getMemberEndpoint();
                jmxManagerSslEnabled = connectToLocatorResult.isJmxManagerSslEnabled();
                this.getGfsh().setOperationInvoker(new JmxOperationInvoker(memberEndpoint.getHost(), memberEndpoint.getPort(), configurationProperties));
                String shellAndLogMessage = CliStrings.format("Successfully connected to: {0}", (Object)("JMX Manager " + memberEndpoint.toString(false)));
                infoResultData.addLine("\n");
                infoResultData.addLine(shellAndLogMessage);
                this.getGfsh().logToFile(shellAndLogMessage, null);
                connectSuccess = true;
                responseFailureMessage = null;
                continue;
            }
            catch (IllegalStateException unexpected) {
                if (CauseFinder.indexOfCause(unexpected, ClassCastException.class, false) == -1) continue;
                responseFailureMessage = "The Locator might require SSL Configuration.";
                continue;
            }
            catch (SecurityException ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                jmxManagerAuthEnabled = true;
                break;
            }
            catch (AuthenticationFailedException ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                jmxManagerAuthEnabled = true;
                break;
            }
            catch (SSLException ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                responseFailureMessage = "Check your SSL configuration and try again.";
                continue;
            }
            catch (Exception ignore) {
                this.getGfsh().logToFile(ignore.getMessage(), ignore);
                responseFailureMessage = "Failed to connect; unknown cause: " + ignore.getMessage();
            }
        }
        if (!connectSuccess) {
            this.doOnConnectionFailure(locatorHostname, locatorPort, jmxManagerAuthEnabled, jmxManagerSslEnabled, infoResultData);
        }
        if (StringUtils.isNotBlank(responseFailureMessage)) {
            infoResultData.addLine("\n");
            infoResultData.addLine(responseFailureMessage);
        }
    }

    private void doOnConnectionFailure(String locatorHostName, int locatorPort, boolean jmxManagerAuthEnabled, boolean jmxManagerSslEnabled, InfoResultData infoResultData) {
        infoResultData.addLine("\n");
        infoResultData.addLine(CliStrings.format("Please use \"{0}\" to connect Gfsh to the locator.", (Object)new CommandStringBuilder("connect").addOption("locator", locatorHostName + "[" + locatorPort + "]").toString()));
        StringBuilder message = new StringBuilder();
        if (jmxManagerAuthEnabled) {
            message.append("Authentication");
        }
        if (jmxManagerSslEnabled) {
            message.append(jmxManagerAuthEnabled ? " and " : "").append("SSL configuration");
        }
        if (jmxManagerAuthEnabled || jmxManagerSslEnabled) {
            message.append(" required to connect to the Manager.");
            infoResultData.addLine("\n");
            infoResultData.addLine(message.toString());
        }
    }

    String[] createStartLocatorCommandLine(LocatorLauncher launcher, File gemfirePropertiesFile, File gemfireSecurityPropertiesFile, Properties gemfireProperties, String userClasspath, Boolean includeSystemClasspath, String[] jvmArgsOpts, String initialHeap, String maxHeap) throws MalformedObjectNameException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(StartMemberUtils.getJavaPath());
        commandLine.add("-server");
        commandLine.add("-classpath");
        commandLine.add(this.getLocatorClasspath(Boolean.TRUE.equals(includeSystemClasspath), userClasspath));
        StartMemberUtils.addCurrentLocators(this, commandLine, gemfireProperties);
        StartMemberUtils.addGemFirePropertyFile(commandLine, gemfirePropertiesFile);
        StartMemberUtils.addGemFireSecurityPropertyFile(commandLine, gemfireSecurityPropertiesFile);
        StartMemberUtils.addGemFireSystemProperties(commandLine, gemfireProperties);
        StartMemberUtils.addJvmArgumentsAndOptions(commandLine, jvmArgsOpts);
        StartMemberUtils.addInitialHeap(commandLine, initialHeap);
        StartMemberUtils.addMaxHeap(commandLine, maxHeap);
        commandLine.add("-D".concat("gemfire.launcher.registerSignalHandlers".concat("=true")));
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dsun.rmi.dgc.server.gcInterval".concat("=").concat(Long.toString(0x7FFFFFFFFFFFFFFEL)));
        commandLine.add(LocatorLauncher.class.getName());
        commandLine.add(LocatorLauncher.Command.START.getName());
        if (StringUtils.isNotBlank((String)launcher.getMemberName())) {
            commandLine.add(launcher.getMemberName());
        }
        if (launcher.getBindAddress() != null) {
            commandLine.add("--bind-address=" + launcher.getBindAddress().getCanonicalHostName());
        }
        if (launcher.isDebugging() || this.isDebugging()) {
            commandLine.add("--debug");
        }
        if (launcher.isForcing()) {
            commandLine.add("--force");
        }
        if (StringUtils.isNotBlank((String)launcher.getHostnameForClients())) {
            commandLine.add("--hostname-for-clients=" + launcher.getHostnameForClients());
        }
        if (launcher.getPort() != null) {
            commandLine.add("--port=" + launcher.getPort());
        }
        if (launcher.isRedirectingOutput()) {
            commandLine.add("--redirect-output");
        }
        return commandLine.toArray(new String[commandLine.size()]);
    }

    String getLocatorClasspath(boolean includeSystemClasspath, String userClasspath) {
        return StartMemberUtils.toClasspath(includeSystemClasspath, new String[]{StartMemberUtils.CORE_DEPENDENCIES_JAR_PATHNAME}, userClasspath);
    }
}

