/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.partitioned.ColocatedRegionDetails;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ShowMissingDiskStoresFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultDataException;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

public class ShowMissingDiskStoreCommand
implements GfshCommand {
    @CliCommand(value={"show missing-disk-stores"}, help="Display a summary of the disk stores that are currently missing from a distributed system.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result showMissingDiskStore() {
        try {
            Set<DistributedMember> dataMembers = DiskStoreCommandsUtils.getNormalMembers(this.getCache());
            if (dataMembers.isEmpty()) {
                return ResultBuilder.createInfoResult("No caching members found.");
            }
            List<Object> results = this.getMissingDiskStoresList(dataMembers);
            return this.toMissingDiskStoresTabularResult(results);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"show missing-disk-stores"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (t.getMessage() == null) {
                return ResultBuilder.createGemFireErrorResult(String.format("An error occurred while showing missing disk stores and missing colocated regions: %1$s", t));
            }
            return ResultBuilder.createGemFireErrorResult(String.format("An error occurred while showing missing disk stores and missing colocated regions: %1$s", t.getMessage()));
        }
    }

    private List<Object> getMissingDiskStoresList(Set<DistributedMember> members) {
        Execution membersFunctionExecutor = this.getMembersFunctionExecutor(members);
        if (membersFunctionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)membersFunctionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultCollector = membersFunctionExecutor.execute(new ShowMissingDiskStoresFunction());
        List results = (List)resultCollector.getResult();
        ArrayList<Object> distributedPersistentRecoveryDetails = new ArrayList<Object>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            distributedPersistentRecoveryDetails.addAll((Set)result);
        }
        return distributedPersistentRecoveryDetails;
    }

    private Result toMissingDiskStoresTabularResult(List<Object> resultDetails) throws ResultDataException {
        boolean hasMissingColocatedRegions;
        CompositeResultData crd = ResultBuilder.createCompositeResultData();
        ArrayList<PersistentMemberPattern> missingDiskStores = new ArrayList<PersistentMemberPattern>();
        ArrayList<ColocatedRegionDetails> missingColocatedRegions = new ArrayList<ColocatedRegionDetails>();
        for (Object detail : resultDetails) {
            if (detail instanceof PersistentMemberPattern) {
                missingDiskStores.add((PersistentMemberPattern)detail);
                continue;
            }
            if (detail instanceof ColocatedRegionDetails) {
                missingColocatedRegions.add((ColocatedRegionDetails)detail);
                continue;
            }
            throw new ResultDataException("Unknown type of PersistentRecoveryFailures result");
        }
        boolean hasMissingDiskStores = !missingDiskStores.isEmpty();
        boolean bl = hasMissingColocatedRegions = !missingColocatedRegions.isEmpty();
        if (hasMissingDiskStores) {
            CompositeResultData.SectionResultData missingDiskStoresSection = crd.addSection();
            missingDiskStoresSection.setHeader("Missing Disk Stores");
            TabularResultData missingDiskStoreData = missingDiskStoresSection.addTable();
            for (PersistentMemberPattern persistentMemberDetails : missingDiskStores) {
                missingDiskStoreData.accumulate("Disk Store ID", persistentMemberDetails.getUUID());
                missingDiskStoreData.accumulate("Host", persistentMemberDetails.getHost());
                missingDiskStoreData.accumulate("Directory", persistentMemberDetails.getDirectory());
            }
        } else {
            CompositeResultData.SectionResultData noMissingDiskStores = crd.addSection();
            noMissingDiskStores.setHeader("No missing disk store found");
        }
        if (hasMissingDiskStores || hasMissingColocatedRegions) {
            crd.addSection().setHeader("\n");
        }
        if (hasMissingColocatedRegions) {
            CompositeResultData.SectionResultData missingRegionsSection = crd.addSection();
            missingRegionsSection.setHeader("Missing Colocated Regions");
            TabularResultData missingRegionData = missingRegionsSection.addTable();
            for (ColocatedRegionDetails colocatedRegionDetails : missingColocatedRegions) {
                missingRegionData.accumulate("Host", colocatedRegionDetails.getHost());
                missingRegionData.accumulate("Distributed Member", colocatedRegionDetails.getMember());
                missingRegionData.accumulate("Parent Region", colocatedRegionDetails.getParent());
                missingRegionData.accumulate("Missing Colocated Region", colocatedRegionDetails.getChild());
            }
        } else {
            CompositeResultData.SectionResultData noMissingColocatedRegions = crd.addSection();
            noMissingColocatedRegions.setHeader("No missing colocated region found");
        }
        return ResultBuilder.buildResult(crd);
    }
}

