/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.RebalanceFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class RebalanceCommand
implements GfshCommand {
    @CliCommand(value={"rebalance"}, help="Rebalance partitioned regions. The default is for all partitioned regions to be rebalanced.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result rebalance(@CliOption(key={"include-region"}, help="Partitioned regions to be included when rebalancing. Includes take precedence over excludes.") String[] includeRegions, @CliOption(key={"exclude-region"}, help="Partitioned regions to be excluded when rebalancing.") String[] excludeRegions, @CliOption(key={"time-out"}, unspecifiedDefaultValue="-1", help="Time to wait (in seconds) before GFSH returns to a prompt while rebalancing continues in the background. The default is to wait for rebalancing to complete.") long timeout, @CliOption(key={"simulate"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to only simulate rebalancing. The --time-out parameter is not available when simulating.") boolean simulate) throws Exception {
        Result result;
        ExecutorService commandExecutors = Executors.newSingleThreadExecutor();
        ArrayList<Future<Result>> commandResult = new ArrayList<Future<Result>>();
        try {
            commandResult.add(commandExecutors.submit(new ExecuteRebalanceWithTimeout(includeRegions, excludeRegions, simulate)));
            Future fs = (Future)commandResult.get(0);
            result = timeout > 0L ? (Result)fs.get(timeout, TimeUnit.SECONDS) : (Result)fs.get();
        }
        catch (TimeoutException timeoutException) {
            result = ResultBuilder.createInfoResult("Rebalance will continue in background");
        }
        LogWrapper.getInstance().info("Rebalance returning result >>>" + result);
        return result;
    }

    private boolean checkResultList(CompositeResultData rebalanceResultData, List resultList, DistributedMember member) {
        boolean toContinueForOtherMembers = false;
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            for (Object object : resultList) {
                if (object instanceof Exception) {
                    rebalanceResultData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Exception)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                } else {
                    if (!(object instanceof Throwable)) continue;
                    rebalanceResultData.addSection().addData(CliStrings.format("Could not execute for member:{0}", (Object)member.getId()), ((Throwable)object).getMessage());
                    LogWrapper.getInstance().info("Could not execute for member:{0}" + member.getId() + " exception=" + ((Throwable)object).getMessage(), (Throwable)object);
                    toContinueForOtherMembers = true;
                }
                break;
            }
        } else {
            LogWrapper.getInstance().info("Rebalancing for member=" + member.getId() + ", resultList is either null or empty");
            rebalanceResultData.addSection().addData("Rebalancing for member=" + member.getId(), ", resultList is either null or empty");
            toContinueForOtherMembers = true;
        }
        return toContinueForOtherMembers;
    }

    private CompositeResultData toCompositeResultData(CompositeResultData rebalanceResultData, List<String> rstlist, int index, boolean simulate, InternalCache cache) {
        int resultItemCount = 9;
        if (rstlist.size() > resultItemCount && StringUtils.isNotEmpty((String)rstlist.get(resultItemCount))) {
            TabularResultData table1 = rebalanceResultData.addSection().addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(0));
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(rstlist.get(0)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            table1.accumulate("Value", rstlist.get(1));
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(rstlist.get(1)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            table1.accumulate("Value", rstlist.get(2));
            resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(rstlist.get(2)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(3));
            resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(rstlist.get(3)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(4));
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(rstlist.get(4)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            table1.accumulate("Value", rstlist.get(5));
            resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(rstlist.get(5)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            table1.accumulate("Value", rstlist.get(6));
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(rstlist.get(6)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            table1.accumulate("Value", rstlist.get(7));
            resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(rstlist.get(7)).append(newLine);
            table1.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            table1.accumulate("Value", rstlist.get(8));
            resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(rstlist.get(8)).append(newLine);
            String headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            for (int i = resultItemCount; i < rstlist.size(); ++i) {
                headerText = headerText + " " + rstlist.get(i);
            }
            table1.setHeader(headerText);
            cache.getLogger().info(headerText + resultStr);
        }
        return rebalanceResultData;
    }

    private DistributedMember getAssociatedMembers(String region, InternalCache cache) {
        DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region);
        DistributedMember member = null;
        if (bean == null) {
            return null;
        }
        String[] membersName = bean.getMembers();
        Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
        Iterator<DistributedMember> it = dsMembers.iterator();
        boolean matchFound = false;
        if (membersName.length > 1) {
            block0: while (it.hasNext() && !matchFound) {
                DistributedMember dsmember = it.next();
                for (String memberName : membersName) {
                    if (!MBeanJMXAdapter.getMemberNameOrId(dsmember).equals(memberName)) continue;
                    member = dsmember;
                    matchFound = true;
                    continue block0;
                }
            }
        }
        return member;
    }

    private CompositeResultData buildResultForRebalance(CompositeResultData rebalanceResultData, RebalanceResults results, int index, boolean simulate, InternalCache cache) {
        Set<PartitionRebalanceInfo> regions = results.getPartitionRebalanceDetails();
        Iterator<PartitionRebalanceInfo> iterator = regions.iterator();
        if (regions.size() > 0 && StringUtils.isNotEmpty((String)iterator.next().getRegionPath())) {
            TabularResultData resultData = rebalanceResultData.addSection().addTable("Table" + index);
            String newLine = System.getProperty("line.separator");
            StringBuilder resultStr = new StringBuilder();
            resultStr.append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in all redundant bucket copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateBytes());
            resultStr.append("Total bytes in all redundant bucket copies created during this rebalance").append(" = ").append(results.getTotalBucketCreateBytes()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent creating redundant bucket copies during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreateTime());
            resultStr.append("Total time (in milliseconds) spent creating redundant bucket copies during this rebalance").append(" = ").append(results.getTotalBucketCreateTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of redundant copies created during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketCreatesCompleted());
            resultStr.append("Total number of redundant copies created during this rebalance").append(" = ").append(results.getTotalBucketCreatesCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total bytes in buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferBytes());
            resultStr.append("Total bytes in buckets moved during this rebalance").append(" = ").append(results.getTotalBucketTransferBytes()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent moving buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransferTime());
            resultStr.append("Total time (in milliseconds) spent moving buckets during this rebalance").append(" = ").append(results.getTotalBucketTransferTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total number of buckets moved during this rebalance");
            resultData.accumulate("Value", results.getTotalBucketTransfersCompleted());
            resultStr.append("Total number of buckets moved during this rebalance").append(" = ").append(results.getTotalBucketTransfersCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) spent switching the primary state of buckets during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransferTime());
            resultStr.append("Total time (in milliseconds) spent switching the primary state of buckets during this rebalance").append(" = ").append(results.getTotalPrimaryTransferTime()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total primaries transferred during this rebalance");
            resultData.accumulate("Value", results.getTotalPrimaryTransfersCompleted());
            resultStr.append("Total primaries transferred during this rebalance").append(" = ").append(results.getTotalPrimaryTransfersCompleted()).append(newLine);
            resultData.accumulate("Rebalanced Stats", "Total time (in milliseconds) for this rebalance");
            resultData.accumulate("Value", results.getTotalTime());
            resultStr.append("Total time (in milliseconds) for this rebalance").append(" = ").append(results.getTotalTime()).append(newLine);
            Iterator<PartitionRebalanceInfo> it = regions.iterator();
            String headerText = simulate ? "Simulated partition regions " : "Rebalanced partition regions ";
            while (it.hasNext()) {
                PartitionRebalanceInfo rgn = it.next();
                headerText = headerText + " " + rgn.getRegionPath();
            }
            resultData.setHeader(resultData.getHeader() + headerText);
            cache.getLogger().info(headerText + resultStr);
        }
        return rebalanceResultData;
    }

    private Result executeRebalanceOnDS(InternalCache cache, String simulate, String[] excludeRegionsList) {
        List<MemberPRInfo> listMemberRegion;
        CommandResult result = null;
        int index = 1;
        CompositeResultData rebalanceResultData = ResultBuilder.createCompositeResultData();
        ArrayList<String> listExcludedRegion = new ArrayList<String>();
        if (excludeRegionsList != null) {
            Collections.addAll(listExcludedRegion, excludeRegionsList);
        }
        if ((listMemberRegion = this.getMemberRegionList(cache, listExcludedRegion)).size() == 0) {
            return ResultBuilder.createInfoResult("Distributed system has no regions that can be rebalanced");
        }
        Iterator<MemberPRInfo> iterator = listMemberRegion.iterator();
        boolean flagToContinueWithRebalance = false;
        while (iterator.hasNext()) {
            if (iterator.next().dsMemberList.size() <= 1) continue;
            flagToContinueWithRebalance = true;
            break;
        }
        if (!flagToContinueWithRebalance) {
            return ResultBuilder.createInfoResult("Distributed system has no regions that can be rebalanced");
        }
        block5: for (MemberPRInfo memberPR : listMemberRegion) {
            try {
                if (memberPR.dsMemberList.size() <= 1) continue;
                for (int i = 0; i < memberPR.dsMemberList.size(); ++i) {
                    List<String> rstList;
                    HashSet excludeRegionSet;
                    DistributedMember dsMember = memberPR.dsMemberList.get(i);
                    RebalanceFunction rebalanceFunction = new RebalanceFunction();
                    Object[] functionArgs = new Object[3];
                    functionArgs[0] = simulate;
                    HashSet<String> regionSet = new HashSet<String>();
                    regionSet.add(memberPR.region);
                    functionArgs[1] = regionSet;
                    functionArgs[2] = excludeRegionSet = new HashSet();
                    ArrayList resultList = null;
                    try {
                        if (this.checkMemberPresence(dsMember, cache)) {
                            resultList = (ArrayList)this.executeFunction((Function)rebalanceFunction, (Object)functionArgs, dsMember).getResult();
                            if (this.checkResultList(rebalanceResultData, resultList, dsMember)) {
                                result = ResultBuilder.buildResult(rebalanceResultData);
                                continue;
                            }
                            rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                            result = ResultBuilder.buildResult(this.toCompositeResultData(rebalanceResultData, rstList, index, simulate.equals("true"), cache));
                            ++index;
                            continue block5;
                        }
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        rebalanceResultData.addSection().addData(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)), " Reason : Members may be departed");
                        result = ResultBuilder.buildResult(rebalanceResultData);
                    }
                    catch (Exception ex) {
                        if (i != memberPR.dsMemberList.size() - 1) continue;
                        rebalanceResultData.addSection().addData(CliStrings.format("Could not execute rebalance for region: {0} on members : {1} ", memberPR.region, this.listOfAllMembers(memberPR.dsMemberList)), " Reason : " + ex.getMessage());
                        result = ResultBuilder.buildResult(rebalanceResultData);
                    }
                    if (this.checkResultList(rebalanceResultData, resultList, dsMember)) {
                        result = ResultBuilder.buildResult(rebalanceResultData);
                        continue;
                    }
                    rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                    result = ResultBuilder.buildResult(this.toCompositeResultData(rebalanceResultData, rstList, index, simulate.equals("true"), cache));
                    ++index;
                }
            }
            catch (Exception e) {
                ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
                return ResultBuilder.buildResult(errorResultData);
            }
        }
        return result;
    }

    private List<MemberPRInfo> getMemberRegionList(InternalCache cache, List<String> listExcludedRegion) {
        ArrayList<MemberPRInfo> listMemberPRInfo = new ArrayList<MemberPRInfo>();
        String[] listDSRegions = ManagementService.getManagementService(cache).getDistributedSystemMXBean().listRegions();
        Set<DistributedMember> dsMembers = CliUtil.getAllMembers(cache);
        for (String regionName : listDSRegions) {
            DistributedRegionMXBean bean;
            boolean excludedRegionMatch = false;
            for (String aListExcludedRegion : listExcludedRegion) {
                String excludedRegion = aListExcludedRegion.trim();
                if (regionName.startsWith("/") && !excludedRegion.startsWith("/")) {
                    excludedRegion = "/" + excludedRegion;
                }
                if (excludedRegion.startsWith("/") && !regionName.startsWith("/")) {
                    regionName = "/" + regionName;
                }
                if (!excludedRegion.equals(regionName)) continue;
                excludedRegionMatch = true;
                break;
            }
            if (excludedRegionMatch) continue;
            if (!regionName.startsWith("/")) {
                regionName = "/" + regionName;
            }
            if ((bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(regionName)) == null || !bean.getRegionType().equals(DataPolicy.PARTITION.toString()) && !bean.getRegionType().equals(DataPolicy.PERSISTENT_PARTITION.toString())) continue;
            String[] memberNames = bean.getMembers();
            block2: for (DistributedMember dsmember : dsMembers) {
                for (String memberName : memberNames) {
                    if (!MBeanJMXAdapter.getMemberNameOrId(dsmember).equals(memberName)) continue;
                    MemberPRInfo memberAndItsPRRegions = new MemberPRInfo();
                    memberAndItsPRRegions.region = regionName;
                    memberAndItsPRRegions.dsMemberList.add(dsmember);
                    if (listMemberPRInfo.contains(memberAndItsPRRegions)) {
                        int index = listMemberPRInfo.indexOf(memberAndItsPRRegions);
                        MemberPRInfo listMember = (MemberPRInfo)listMemberPRInfo.get(index);
                        listMember.dsMemberList.add(dsmember);
                        continue block2;
                    }
                    listMemberPRInfo.add(memberAndItsPRRegions);
                    continue block2;
                }
            }
        }
        return listMemberPRInfo;
    }

    private boolean checkMemberPresence(DistributedMember dsMember, InternalCache cache) {
        Set<DistributedMember> dsMemberList = CliUtil.getAllNormalMembers(cache);
        return dsMemberList.contains(dsMember);
    }

    private String listOfAllMembers(ArrayList<DistributedMember> dsMemberList) {
        StringBuilder listMembersId = new StringBuilder();
        for (int j = 0; j < dsMemberList.size() - 1; ++j) {
            listMembersId.append(dsMemberList.get(j).getId());
            listMembersId.append(" ; ");
        }
        return listMembersId.toString();
    }

    private static class MemberPRInfo {
        ArrayList<DistributedMember> dsMemberList = new ArrayList();
        public String region = "";

        MemberPRInfo() {
        }

        public boolean equals(Object o2) {
            return o2 != null && this.region.equals(((MemberPRInfo)o2).region);
        }
    }

    private class ExecuteRebalanceWithTimeout
    implements Callable<Result> {
        String[] includeRegions = null;
        String[] excludeRegions = null;
        boolean simulate;
        InternalCache cache = RebalanceCommand.this.getCache();

        @Override
        public Result call() throws Exception {
            return this.executeRebalanceWithTimeout(this.includeRegions, this.excludeRegions, this.simulate);
        }

        ExecuteRebalanceWithTimeout(String[] includedRegions, String[] excludedRegions, boolean toSimulate) {
            this.includeRegions = includedRegions;
            this.excludeRegions = excludedRegions;
            this.simulate = toSimulate;
        }

        Result executeRebalanceWithTimeout(String[] includeRegions, String[] excludeRegions, boolean simulate) {
            Result result = null;
            try {
                if (ArrayUtils.isNotEmpty((Object[])includeRegions)) {
                    CompositeResultData rebalanceResultData = ResultBuilder.createCompositeResultData();
                    int index = 0;
                    for (String regionName : includeRegions) {
                        regionName = regionName.startsWith("/") ? regionName : "/" + regionName;
                        Region region = this.cache.getRegion(regionName);
                        if (region == null) {
                            List<String> rstList;
                            ArrayList resultList;
                            DistributedMember member = RebalanceCommand.this.getAssociatedMembers(regionName, this.cache);
                            if (member == null) {
                                LogWrapper.getInstance().info(CliStrings.format("For the region {0}, no member was found", (Object)regionName));
                                continue;
                            }
                            RebalanceFunction rebalanceFunction = new RebalanceFunction();
                            Object[] functionArgs = new Object[3];
                            functionArgs[0] = simulate ? "true" : "false";
                            HashSet<String> setRegionName = new HashSet<String>();
                            setRegionName.add(regionName);
                            functionArgs[1] = setRegionName;
                            HashSet excludeRegionSet = new HashSet();
                            if (ArrayUtils.isNotEmpty((Object[])excludeRegions)) {
                                Collections.addAll(excludeRegionSet, excludeRegions);
                            }
                            functionArgs[2] = excludeRegionSet;
                            if (simulate) {
                                try {
                                    resultList = (ArrayList)RebalanceCommand.this.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance().info(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    rebalanceResultData.addSection().addData(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is ", (Object)member.getId()), ex.getMessage());
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                if (RebalanceCommand.this.checkResultList(rebalanceResultData, resultList, member)) {
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                                result = ResultBuilder.buildResult(RebalanceCommand.this.toCompositeResultData(rebalanceResultData, rstList, index, true, this.cache));
                            } else {
                                try {
                                    resultList = (ArrayList)RebalanceCommand.this.executeFunction((Function)rebalanceFunction, (Object)functionArgs, member).getResult();
                                }
                                catch (Exception ex) {
                                    LogWrapper.getInstance().info(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is : {1}", member.getId(), ex.getMessage()), ex);
                                    rebalanceResultData.addSection().addData(CliStrings.format("Exception occurred while rebalancing on member : {0} . Exception is ", (Object)member.getId()), ex.getMessage());
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                if (RebalanceCommand.this.checkResultList(rebalanceResultData, resultList, member)) {
                                    result = ResultBuilder.buildResult(rebalanceResultData);
                                    continue;
                                }
                                rstList = Arrays.asList(((String)resultList.get(0)).split(","));
                                result = ResultBuilder.buildResult(RebalanceCommand.this.toCompositeResultData(rebalanceResultData, rstList, index, false, this.cache));
                            }
                        } else {
                            RebalanceOperation op;
                            ResourceManager manager = this.cache.getResourceManager();
                            RebalanceFactory rbFactory = manager.createRebalanceFactory();
                            HashSet<String> excludeRegionSet = new HashSet<String>();
                            if (excludeRegions != null) {
                                Collections.addAll(excludeRegionSet, excludeRegions);
                            }
                            rbFactory.excludeRegions(excludeRegionSet);
                            HashSet<String> includeRegionSet = new HashSet<String>();
                            includeRegionSet.add(regionName);
                            rbFactory.includeRegions(includeRegionSet);
                            if (simulate) {
                                op = manager.createRebalanceFactory().simulate();
                                result = ResultBuilder.buildResult(RebalanceCommand.this.buildResultForRebalance(rebalanceResultData, op.getResults(), index, true, this.cache));
                            } else {
                                op = manager.createRebalanceFactory().start();
                                result = ResultBuilder.buildResult(RebalanceCommand.this.buildResultForRebalance(rebalanceResultData, op.getResults(), index, false, this.cache));
                            }
                        }
                        ++index;
                    }
                    LogWrapper.getInstance().info("Rebalance returning result " + result);
                    return result;
                }
                result = RebalanceCommand.this.executeRebalanceOnDS(this.cache, String.valueOf(simulate), excludeRegions);
                LogWrapper.getInstance().info("Starting Rebalance simulate false result >> " + result);
            }
            catch (Exception e) {
                result = ResultBuilder.createGemFireErrorResult(e.getMessage());
            }
            LogWrapper.getInstance().info("Rebalance returning result >>>" + result);
            return result;
        }
    }
}

