/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.QCompiler;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class QueryCommand
implements GfshCommand {
    private static final Logger logger = LogService.getLogger();

    @CliCommand(value={"query"}, help="Run the specified OQL query as a single quoted string and display the results in one or more pages. Limit will default to the value stored in the \"APP_FETCH_SIZE\" variable. Page size will default to the value stored in the \"APP_COLLECTION_LIMIT\" variable.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.QueryInterceptor")
    public Result query(@CliOption(key={"query"}, help="The OQL string.", mandatory=true) String query, @CliOption(key={"file"}, help="File in which to output the results.", optionContext="geode.converter.file") File outputFile, @CliOption(key={"interactive"}, unspecifiedDefaultValue="false", help="Deprecated. This option has no effect, but is kept around to maintain backwards compatibility with existing scripts.") boolean interactive) {
        DataCommandResult dataResult = this.select(query);
        CompositeResultData rd = dataResult.toSelectCommandResult();
        return ResultBuilder.buildResult(rd);
    }

    private DataCommandResult select(String query) {
        InternalCache cache = (InternalCache)CacheFactory.getAnyInstance();
        if (StringUtils.isEmpty((String)query)) {
            DataCommandResult dataResult = DataCommandResult.createSelectInfoResult(null, null, -1, null, "Query is either empty or Null", false);
            return dataResult;
        }
        boolean limitAdded = false;
        if (!StringUtils.containsIgnoreCase((String)query, (String)" limit") && !StringUtils.containsIgnoreCase((String)query, (String)" count(")) {
            query = query + " limit " + CommandExecutionContext.getShellFetchSize();
            limitAdded = true;
        }
        QCompiler compiler = new QCompiler();
        try {
            CompiledValue compiledQuery = compiler.compileQuery(query);
            HashSet regions = new HashSet();
            compiledQuery.getRegionsInQuery(regions, null);
            for (String region : regions) {
                cache.getSecurityService().authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, region);
            }
            Set<String> regionsInQuery = Collections.unmodifiableSet(regions);
            if (regionsInQuery.size() > 0) {
                Set<DistributedMember> members = CliUtil.getQueryRegionsAssociatedMembers(regionsInQuery, cache, false);
                if (members != null && members.size() > 0) {
                    DataCommandFunction function = new DataCommandFunction();
                    DataCommandRequest request = new DataCommandRequest();
                    request.setCommand("query");
                    request.setQuery(query);
                    Subject subject = cache.getSecurityService().getSubject();
                    if (subject != null) {
                        request.setPrincipal(subject.getPrincipal());
                    }
                    DataCommandResult dataResult = QueryCommand.callFunctionForRegion(request, function, members);
                    dataResult.setInputQuery(query);
                    if (limitAdded) {
                        dataResult.setLimit(CommandExecutionContext.getShellFetchSize());
                    }
                    return dataResult;
                }
                return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Cannot find regions <{0}> in any of the members", (Object)regionsInQuery.toString()), false);
            }
            return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Query is invalid due for error : <{0}>", (Object)"Region mentioned in query probably missing /"), false);
        }
        catch (QueryInvalidException qe) {
            logger.error("{} Failed Error {}", (Object)query, (Object)qe.getMessage(), (Object)qe);
            return DataCommandResult.createSelectInfoResult(null, null, -1, null, CliStrings.format("Query is invalid due for error : <{0}>", (Object)qe.getMessage()), false);
        }
    }

    public static DataCommandResult callFunctionForRegion(DataCommandRequest request, DataCommandFunction putfn, Set<DistributedMember> members) {
        if (members.size() == 1) {
            DistributedMember member = members.iterator().next();
            ResultCollector collector = FunctionService.onMember(member).setArguments(request).execute(putfn);
            List list = (List)collector.getResult();
            Object object = list.get(0);
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                DataCommandResult result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            DataCommandResult result = (DataCommandResult)list.get(0);
            result.aggregate(null);
            return result;
        }
        ResultCollector collector = FunctionService.onMembers(members).setArguments(request).execute(putfn);
        List list = (List)collector.getResult();
        DataCommandResult result = null;
        for (Object object : list) {
            if (object instanceof Throwable) {
                Throwable error = (Throwable)object;
                result = new DataCommandResult();
                result.setErorr(error);
                result.setErrorString(error.getMessage());
                return result;
            }
            if (result == null) {
                result = (DataCommandResult)object;
                result.aggregate(null);
                continue;
            }
            result.aggregate((DataCommandResult)object);
        }
        return result;
    }
}

