/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GatewayCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LoadBalanceGatewaySenderCommand
implements GfshCommand {
    @CliCommand(value={"load-balance gateway-sender"}, help="Cause the Gateway Sender to close its current connections so that it reconnects to its remote receivers in a more balanced fashion.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result loadBalanceGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="ID of the Gateway Sender.") String senderId) {
        Result result;
        if (senderId != null) {
            senderId = senderId.trim();
        }
        InternalCache cache = this.getCache();
        SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
        TabularResultData resultData = ResultBuilder.createTabularResultData();
        Set<DistributedMember> dsMembers = CliUtil.getAllNormalMembers(cache);
        if (dsMembers.isEmpty()) {
            result = ResultBuilder.createInfoResult("Members not found");
        } else {
            boolean gatewaySenderExists = false;
            for (DistributedMember member : dsMembers) {
                GatewaySenderMXBean bean;
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(senderId);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                    bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    gatewaySenderExists = true;
                    bean.rebalance();
                    GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewaySender {0} is rebalanced on member {1}", senderId, member.getId()));
                    continue;
                }
                GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not available on member {1}", senderId, member.getId()));
            }
            result = gatewaySenderExists ? ResultBuilder.buildResult(resultData) : ResultBuilder.createInfoResult(CliStrings.format("GatewaySender {0} is not found on any member", new Object[]{senderId}));
        }
        return result;
    }
}

