/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.RegionInformation;
import org.apache.geode.management.internal.cli.functions.GetRegionsFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListRegionCommand
implements GfshCommand {
    private static final GetRegionsFunction getRegionsFunction = new GetRegionsFunction();

    @CliCommand(value={"list regions"}, help="Display regions of a member or members.")
    @CliMetaData(relatedTopic={"Region"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listRegion(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members for which regions will be displayed.") String[] group, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member for which regions will be displayed.") String[] memberNameOrId) {
        Result result = null;
        try {
            LinkedHashSet regionInfoSet = new LinkedHashSet();
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrId);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            ResultCollector<?, ?> rc = CliUtil.executeFunction(getRegionsFunction, null, targetMembers);
            ArrayList resultList = (ArrayList)rc.getResult();
            if (resultList != null) {
                regionInfoSet.addAll(resultList.stream().filter(Objects::nonNull).filter(Object[].class::isInstance).map(Object[].class::cast).flatMap(Arrays::stream).filter(RegionInformation.class::isInstance).map(RegionInformation.class::cast).collect(Collectors.toSet()));
                TreeSet<String> regionNames = new TreeSet<String>();
                for (RegionInformation regionInfo : regionInfoSet) {
                    regionNames.add(regionInfo.getName());
                    Set<String> subRegionNames = regionInfo.getSubRegionNames();
                    regionNames.addAll(subRegionNames);
                }
                for (String regionName : regionNames) {
                    resultData.accumulate("List of regions", regionName);
                }
                result = !regionNames.isEmpty() ? ResultBuilder.buildResult(resultData) : ResultBuilder.createInfoResult("No Regions Found");
            }
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"list regions"));
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult("Error occurred while fetching list of regions. : " + e.getMessage());
        }
        return result;
    }
}

