/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.TreeSet;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListMembersCommand
implements GfshCommand {
    @CliCommand(value={"list members"}, help="Display all or a subset of members.")
    @CliMetaData(relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listMember(@CliOption(key={"group"}, unspecifiedDefaultValue="", optionContext="geode.converter.member.groups:disable-string-converter", help="Group name for which members will be displayed.") String group) {
        Result result;
        try {
            TreeSet<DistributedMember> memberSet = new TreeSet<DistributedMember>();
            InternalCache cache = this.getCache();
            if (group.isEmpty()) {
                memberSet.addAll(CliUtil.getAllMembers(cache));
            } else {
                memberSet.addAll(cache.getDistributedSystem().getGroupMembers(group));
            }
            if (memberSet.isEmpty()) {
                result = ResultBuilder.createInfoResult("No Members Found");
            } else {
                TabularResultData resultData = ResultBuilder.createTabularResultData();
                String coordinatorMember = this.getCoordinator();
                resultData.accumulate("Name", "Coordinator:");
                resultData.accumulate("Id", coordinatorMember);
                for (DistributedMember member : memberSet) {
                    resultData.accumulate("Name", member.getName());
                    resultData.accumulate("Id", member.getId());
                }
                result = ResultBuilder.buildResult(resultData);
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult("Could not fetch the list of members. " + e.getMessage());
            LogWrapper.getInstance().warning(e.getMessage(), e);
        }
        return result;
    }

    private String getCoordinator() {
        MembershipManager mmgr;
        DistributedMember coord;
        String result = "unknown";
        InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
        if (ids != null && ids.isConnected() && (coord = (mmgr = ids.getDistributionManager().getMembershipManager()).getCoordinator()) != null) {
            result = coord.toString();
        }
        return result;
    }
}

