/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListGatewayCommand
implements GfshCommand {
    @CliCommand(value={"list gateways"}, help="Display the Gateway Senders and Receivers for a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listGateway(@CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Member(s) for which Gateway Senders and Receivers will be displayed.") String[] onMember, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members for which Gateway Senders and Receivers will be displayed.") String[] onGroup) throws Exception {
        InternalCache cache = this.getCache();
        SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        TreeMap<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans = new TreeMap<String, Map<String, GatewaySenderMXBean>>();
        TreeMap<String, GatewayReceiverMXBean> gatewayReceiverBeans = new TreeMap<String, GatewayReceiverMXBean>();
        DistributedSystemMXBean dsMXBean = service.getDistributedSystemMXBean();
        for (DistributedMember member : dsMembers) {
            GatewayReceiverMXBean receiverBean;
            ObjectName gatewayReceiverObjectName;
            String memberName = member.getName();
            String memberNameOrId = memberName != null && !memberName.isEmpty() ? memberName : member.getId();
            ObjectName[] gatewaySenderObjectNames = dsMXBean.listGatewaySenderObjectNames(memberNameOrId);
            if (gatewaySenderObjectNames != null) {
                for (ObjectName name : gatewaySenderObjectNames) {
                    Map<String, GatewaySenderMXBean> memberToBeanMap;
                    GatewaySenderMXBean senderBean = service.getMBeanProxy(name, GatewaySenderMXBean.class);
                    if (senderBean == null) continue;
                    if (gatewaySenderBeans.containsKey(senderBean.getSenderId())) {
                        memberToBeanMap = (Map)gatewaySenderBeans.get(senderBean.getSenderId());
                        memberToBeanMap.put(member.getId(), senderBean);
                        continue;
                    }
                    memberToBeanMap = new TreeMap<String, GatewaySenderMXBean>();
                    memberToBeanMap.put(member.getId(), senderBean);
                    gatewaySenderBeans.put(senderBean.getSenderId(), memberToBeanMap);
                }
            }
            if ((gatewayReceiverObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(member)) == null || (receiverBean = service.getMBeanProxy(gatewayReceiverObjectName, GatewayReceiverMXBean.class)) == null) continue;
            gatewayReceiverBeans.put(member.getId(), receiverBean);
        }
        if (gatewaySenderBeans.isEmpty() && gatewayReceiverBeans.isEmpty()) {
            return ResultBuilder.createUserErrorResult("GatewaySenders or GatewayReceivers are not available in cluster");
        }
        CompositeResultData crd = ResultBuilder.createCompositeResultData();
        crd.setHeader("Gateways");
        this.accumulateListGatewayResult(crd, gatewaySenderBeans, gatewayReceiverBeans);
        CommandResult result = ResultBuilder.buildResult(crd);
        return result;
    }

    private void accumulateListGatewayResult(CompositeResultData crd, Map<String, Map<String, GatewaySenderMXBean>> gatewaySenderBeans, Map<String, GatewayReceiverMXBean> gatewayReceiverBeans) {
        if (!gatewaySenderBeans.isEmpty()) {
            TabularResultData gatewaySenderData = crd.addSection("GatewaySender Section").addTable("GatewaySender Table").setHeader("GatewaySender");
            for (Map.Entry<String, Object> entry : gatewaySenderBeans.entrySet()) {
                for (Map.Entry memberToBean : ((Map)entry.getValue()).entrySet()) {
                    gatewaySenderData.accumulate("GatewaySender Id", entry.getKey());
                    gatewaySenderData.accumulate("Member", memberToBean.getKey());
                    gatewaySenderData.accumulate("Remote Cluster Id", ((GatewaySenderMXBean)memberToBean.getValue()).getRemoteDSId());
                    gatewaySenderData.accumulate("Type", ((GatewaySenderMXBean)memberToBean.getValue()).isParallel() ? "Parallel" : "Serial");
                    gatewaySenderData.accumulate("Status", ((GatewaySenderMXBean)memberToBean.getValue()).isRunning() ? "Running" : "Not Running");
                    gatewaySenderData.accumulate("Queued Events", ((GatewaySenderMXBean)memberToBean.getValue()).getEventQueueSize());
                    gatewaySenderData.accumulate("Receiver Location", ((GatewaySenderMXBean)memberToBean.getValue()).getGatewayReceiver());
                }
            }
        }
        if (!gatewayReceiverBeans.isEmpty()) {
            TabularResultData gatewayReceiverData = crd.addSection("GatewayReceiver Section").addTable("GatewayReceiver Table").setHeader("GatewayReceiver");
            for (Map.Entry<String, Object> entry : gatewayReceiverBeans.entrySet()) {
                gatewayReceiverData.accumulate("Member", entry.getKey());
                gatewayReceiverData.accumulate("Port", ((GatewayReceiverMXBean)entry.getValue()).getPort());
                gatewayReceiverData.accumulate("Sender Count", ((GatewayReceiverMXBean)entry.getValue()).getClientConnectionCount());
                gatewayReceiverData.accumulate("Sender's Connected", ((GatewayReceiverMXBean)entry.getValue()).getConnectedGatewaySenders());
            }
        }
    }
}

