/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.springframework.shell.core.annotation.CliCommand;

public class DescribeConnectionCommand
implements GfshCommand {
    @CliCommand(value={"describe connection"}, help="Display information about the current connection.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX"})
    public Result describeConnection() {
        CommandResult result;
        try {
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            Gfsh gfshInstance = this.getGfsh();
            if (gfshInstance.isConnectedAndReady()) {
                OperationInvoker operationInvoker = gfshInstance.getOperationInvoker();
                tabularResultData.accumulate("Connection Endpoints", operationInvoker.toString());
            } else {
                tabularResultData.accumulate("Connection Endpoints", "Not connected");
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (Exception e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
        }
        return result;
    }
}

