/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DeployFunction;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DeployCommand
implements GfshCommand {
    private final DeployFunction deployFunction = new DeployFunction();

    @CliCommand(value={"deploy"}, help="Deploy JARs to a member or members.  Only one of either --jar or --dir may be specified.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.DeployCommand$Interceptor", isFileUploaded=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public Result deploy(@CliOption(key={"group", "groups"}, help="Group(s) to which the specified JARs will be deployed. If not specified, deploy will occur on all members.", optionContext="geode.converter.member.groups:disable-string-converter") String[] groups, @CliOption(key={"jar", "jars"}, help="Path of the JAR to deploy.") String[] jars, @CliOption(key={"dir"}, help="Directory from which to deploy the JARs.") String dir) throws IOException {
        TabularResultData tabularData = ResultBuilder.createTabularResultData();
        List<String> jarFullPaths = CommandExecutionContext.getFilePathFromShell();
        Set<DistributedMember> targetMembers = CliUtil.findMembers(groups, null);
        ArrayList results = new ArrayList();
        ManagementAgent agent = ((SystemManagementService)this.getManagementService()).getManagementAgent();
        RemoteStreamExporter exporter = agent.getRemoteStreamExporter();
        for (DistributedMember distributedMember : targetMembers) {
            ArrayList<Object> remoteStreams = new ArrayList<Object>();
            ArrayList<String> jarNames = new ArrayList<String>();
            for (String jarFullPath : jarFullPaths) {
                remoteStreams.add(exporter.export((RemoteStreamServer)new SimpleRemoteInputStream((InputStream)new FileInputStream(jarFullPath))));
                jarNames.add(FilenameUtils.getName((String)jarFullPath));
            }
            ResultCollector<?, ?> resultCollector = this.executeFunction((Function)this.deployFunction, (Object)new Object[]{jarNames, remoteStreams}, distributedMember);
            results.add(((List)resultCollector.getResult()).get(0));
            for (RemoteInputStream remoteInputStream : remoteStreams) {
                try {
                    remoteInputStream.close(true);
                }
                catch (IOException iOException) {}
            }
        }
        List<CliFunctionResult> cleanedResults = CliFunctionResult.cleanResults(results);
        for (CliFunctionResult result : cleanedResults) {
            if (result.getThrowable() != null) {
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Deployed JAR", "");
                tabularData.accumulate("Deployed JAR Location", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                tabularData.setStatus(Result.Status.ERROR);
                continue;
            }
            String[] strings = (String[])result.getSerializables();
            for (int i = 0; i < strings.length; i += 2) {
                tabularData.accumulate("Member", result.getMemberIdOrName());
                tabularData.accumulate("Deployed JAR", strings[i]);
                tabularData.accumulate("Deployed JAR Location", strings[i + 1]);
            }
        }
        CommandResult commandResult = ResultBuilder.buildResult(tabularData);
        ClusterConfigurationService sc = this.getSharedConfiguration();
        if (sc == null) {
            commandResult.setCommandPersisted(false);
        } else {
            sc.addJarsToThisLocator(jarFullPaths, groups);
            commandResult.setCommandPersisted(true);
        }
        return commandResult;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private final DecimalFormat numFormatter = new DecimalFormat("###,##0.00");

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String message;
            Object[] jars = (String[])parseResult.getParamValue("jar");
            String dir = (String)parseResult.getParamValue("dir");
            if (ArrayUtils.isEmpty((Object[])jars) && StringUtils.isBlank((String)dir)) {
                return ResultBuilder.createUserErrorResult("Parameter \"jar\" or \"dir\" is required. Use \"help <command name>\" for assistance.");
            }
            if (ArrayUtils.isNotEmpty((Object[])jars) && StringUtils.isNotBlank((String)dir)) {
                return ResultBuilder.createUserErrorResult("Parameters \"jar\" and \"dir\" can not both be specified.");
            }
            FileResult fileResult = new FileResult();
            if (jars != null) {
                for (Object jar : jars) {
                    File jarFile = new File((String)jar);
                    if (!jarFile.exists()) {
                        return ResultBuilder.createUserErrorResult((String)jar + " not found.");
                    }
                    fileResult.addFile(jarFile);
                }
            } else {
                File[] childJarFile;
                File fileDir = new File(dir);
                if (!fileDir.isDirectory()) {
                    return ResultBuilder.createUserErrorResult(dir + " is not a directory");
                }
                for (File file : childJarFile = fileDir.listFiles(CliUtil.JAR_FILE_FILTER)) {
                    fileResult.addFile(file);
                }
            }
            if (this.readYesNo(message = "\nDeploying files: " + fileResult.getFormattedFileList() + "\nTotal file size is: " + this.numFormatter.format((double)fileResult.computeFileSizeTotal() / 1048576.0) + "MB\n\nContinue? ", AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultBuilder.createShellClientAbortOperationResult("Aborted deploy of " + fileResult.getFormattedFileList() + ".");
            }
            return fileResult;
        }
    }
}

