/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DebugCommand
implements GfshCommand {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CliCommand(value={"debug"}, help="Enable/Disable debugging output in GFSH.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "Debug-Utility"})
    public Result debug(@CliOption(key={"state"}, unspecifiedDefaultValue="OFF", mandatory=true, optionContext="debug", help="ON or OFF to enable or disable debugging output.") String state) {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance != null) {
            if (state.equalsIgnoreCase("ON")) {
                gfshInstance.setDebug(true);
                return ResultBuilder.createInfoResult("Debug is " + state);
            } else {
                if (!state.equalsIgnoreCase("OFF")) return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid state value : {0}. It should be \"ON\" or \"OFF\" ", (Object)state));
                gfshInstance.setDebug(false);
            }
            return ResultBuilder.createInfoResult("Debug is " + state);
        } else {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Could not get GFSH Instance");
            return ResultBuilder.buildResult(errorResultData);
        }
    }
}

