/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewaySenderCreateFunction;
import org.apache.geode.management.internal.cli.functions.GatewaySenderFunctionArgs;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateGatewaySenderCommand
implements GfshCommand {
    @CliCommand(value={"create gateway-sender"}, help="Create the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"}, interceptor="org.apache.geode.management.internal.cli.commands.CreateGatewaySenderCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result createGatewaySender(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to create the Gateway Sender.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to create the Gateway Sender.") String[] onMember, @CliOption(key={"id"}, mandatory=true, help="Id of the GatewaySender.") String id, @CliOption(key={"remote-distributed-system-id"}, mandatory=true, help="Id of the remote distributed system to which the sender will send events.") Integer remoteDistributedSystemId, @CliOption(key={"parallel"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether this is Parallel GatewaySender.") boolean parallel, @CliOption(key={"manual-start"}, help="Whether manual start is to be enabled or the sender will start automatically after creation.\nDeprecated: Manual start of senders is deprecated and will be removed in a later release.") Boolean manualStart, @CliOption(key={"socket-buffer-size"}, help="The buffer size of the socket connection between this GatewaySender and its receiving GatewayReceiver.") Integer socketBufferSize, @CliOption(key={"socket-read-timeout"}, help="The amount of time in milliseconds that a socket read between a sending GatewaySender and its receiving GatewayReceiver will block.") Integer socketReadTimeout, @CliOption(key={"enable-batch-conflation"}, help="Whether batch conflation is to be enabled for a GatewaySender.") Boolean enableBatchConflation, @CliOption(key={"batch-size"}, help="The batch size for the GatewaySender.") Integer batchSize, @CliOption(key={"batch-time-interval"}, help="The batch time interval for the GatewaySender.") Integer batchTimeInterval, @CliOption(key={"enable-persistence"}, help="Whether persistence is to be enabled for the GatewaySender.") Boolean enablePersistence, @CliOption(key={"disk-store-name"}, help="The disk store name to be configured for overflow or persistence.") String diskStoreName, @CliOption(key={"disk-synchronous"}, help="Whether writes to the disk in case of persistence are synchronous.") Boolean diskSynchronous, @CliOption(key={"maximum-queue-memory"}, help="The maximum amount of memory (in MB) for a GatewaySender's queue.") Integer maxQueueMemory, @CliOption(key={"alert-threshold"}, help="The alert threshold for entries in a GatewaySender's queue.") Integer alertThreshold, @CliOption(key={"dispatcher-threads"}, help="The number of dispatcher threads working for this GatewaySender. When dispatcher threads is set to > 1, appropriate order policy is required to be set.") Integer dispatcherThreads, @CliOption(key={"order-policy"}, help="The order policy followed while dispatching the events to remote distributed system. Order policy is set only when dispatcher threads are > 1. Possible values are 'THREAD', 'KEY', 'PARTITION'.") GatewaySender.OrderPolicy orderPolicy, @CliOption(key={"gateway-event-filter"}, help="The list of fully qualified class names of GatewayEventFilters (separated by comma) to be associated with the GatewaySender. This serves as a callback for users to filter out events before dispatching to remote distributed system. e.g gateway-event-filter=com.user.filters.MyFilter1,com.user.filters.MyFilters2") String[] gatewayEventFilters, @CliOption(key={"gateway-transport-filter"}, help="The fully qualified class name of GatewayTransportFilter to be added to the GatewaySender. ") String[] gatewayTransportFilter) {
        GatewaySenderFunctionArgs gatewaySenderFunctionArgs = new GatewaySenderFunctionArgs(id, remoteDistributedSystemId, parallel, manualStart, socketBufferSize, socketReadTimeout, enableBatchConflation, batchSize, batchTimeInterval, enablePersistence, diskStoreName, diskSynchronous, maxQueueMemory, alertThreshold, dispatcherThreads, orderPolicy == null ? null : orderPolicy.name(), gatewayEventFilters, gatewayTransportFilter);
        Set<DistributedMember> membersToCreateGatewaySenderOn = this.getMembers(onGroups, onMember);
        List<CliFunctionResult> gatewaySenderCreateResults = this.executeAndGetFunctionResult(GatewaySenderCreateFunction.INSTANCE, gatewaySenderFunctionArgs, membersToCreateGatewaySenderOn);
        CommandResult result = ResultBuilder.buildResult(gatewaySenderCreateResults);
        XmlEntity xmlEntity = this.findXmlEntity(gatewaySenderCreateResults);
        if (xmlEntity == null) {
            return result;
        }
        if (onMember != null || this.getSharedConfiguration() == null) {
            result.setCommandPersisted(false);
            return result;
        }
        this.getSharedConfiguration().addXmlEntity(xmlEntity, onGroups);
        return result;
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            Integer dispatcherThreads = (Integer)parseResult.getParamValue("dispatcher-threads");
            GatewaySender.OrderPolicy orderPolicy = (GatewaySender.OrderPolicy)((Object)parseResult.getParamValue("order-policy"));
            Boolean parallel = (Boolean)parseResult.getParamValue("parallel");
            if (dispatcherThreads != null && dispatcherThreads > 1 && orderPolicy == null) {
                return ResultBuilder.createUserErrorResult("Must specify --order-policy when --dispatcher-threads is larger than 1.");
            }
            if (parallel.booleanValue() && orderPolicy == GatewaySender.OrderPolicy.THREAD) {
                return ResultBuilder.createUserErrorResult("Parallel Gateway Sender can not be created with THREAD OrderPolicy");
            }
            return ResultBuilder.createInfoResult("");
        }
    }
}

