/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.DurableClientCommandsResultBuilder;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.GetSubscriptionQueueSizeFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CountDurableCQEventsCommand
implements GfshCommand {
    DurableClientCommandsResultBuilder builder = new DurableClientCommandsResultBuilder();

    @CliCommand(value={"show subscription-queue-size"}, help="Shows the number of events in the subscription queue.  If a cq name is provided, counts the number of events in the subscription queue for the specified cq.")
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result countDurableCqEvents(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client.") String durableClientId, @CliOption(key={"durable-cq-name"}, help="The name that identifies the cq.") String cqName, @CliOption(key={"member", "members"}, help="Name/Id of the member for which the subscription events are to be counted.", optionContext="geode.converter.member.idOrName:disable-string-converter") String[] memberNameOrId, @CliOption(key={"group", "groups"}, help="Group of members for which the subscription queue events are to be counted.", optionContext="geode.converter.member.groups:disable-string-converter") String[] group) {
        Result result;
        try {
            Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrId);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            String[] params = new String[]{durableClientId, cqName};
            ResultCollector<?, ?> rc = CliUtil.executeFunction(new GetSubscriptionQueueSizeFunction(), params, targetMembers);
            List funcResults = (List)rc.getResult();
            String queueSizeColumnName = cqName != null && !cqName.isEmpty() ? CliStrings.format("subscription-queue-size for durable-client : \"{0}\".", (Object)cqName) : CliStrings.format("subscription-queue-size for durable-client : \"{0}\".", (Object)durableClientId);
            result = this.builder.buildTableResultForQueueSize(funcResults, queueSizeColumnName);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }
}

