/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class AlterOfflineDiskStoreCommand
implements GfshCommand {
    @CliCommand(value={"alter disk-store"}, help="Alter some options for a region or remove a region in an offline disk store.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result alterOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store whose contents will be altered.") String diskStoreName, @CliOption(key={"region"}, mandatory=true, help="Name/Path of the region in the disk store to alter.") String regionName, @CliOption(key={"disk-dirs"}, help="Directories where data for the disk store was previously written.", mandatory=true) String[] diskDirs, @CliOption(key={"compressor"}, specifiedDefaultValue="none", help="The fully-qualified class name of the Compressor to use when compressing region entry values. A value of 'none' will remove the Compressor.") String compressorClassName, @CliOption(key={"concurrency-level"}, help="An estimate of the maximum number of application threads that will concurrently modify a region at one time. This attribute does not apply to partitioned regions.") Integer concurrencyLevel, @CliOption(key={"enable-statistics"}, help="Whether to enable statistics. Valid values are: true and false.") Boolean statisticsEnabled, @CliOption(key={"initial-capacity"}, help="Together with --load-factor, sets the parameters on the underlying java.util.ConcurrentHashMap used for storing region entries.") Integer initialCapacity, @CliOption(key={"load-factor"}, help="Together with --initial-capacity, sets the parameters on the underlying java.util.ConcurrentHashMap used for storing region entries. This must be a floating point number between 0 and 1, inclusive.") Float loadFactor, @CliOption(key={"lru-action"}, help="Action to take when evicting entries from the region. Valid values are: none, overflow-to-disk and local-destroy.") String lruEvictionAction, @CliOption(key={"lru-algorithm"}, help="Least recently used eviction algorithm.  Valid values are: none, lru-entry-count, lru-heap-percentage and lru-memory-size.") String lruEvictionAlgo, @CliOption(key={"lru-limit"}, help="Number of entries allowed in the region before eviction will occur.") Integer lruEvictionLimit, @CliOption(key={"off-heap"}, help="Whether to use off-heap memory for the region. Valid values are: true and false.") Boolean offHeap, @CliOption(key={"remove"}, help="Whether to remove the region from the disk store.", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean remove) {
        Result result;
        try {
            File[] dirs = null;
            if (diskDirs != null) {
                dirs = new File[diskDirs.length];
                for (int i = 0; i < diskDirs.length; ++i) {
                    dirs[i] = new File(diskDirs[i]);
                }
            }
            if (regionName.equals("/")) {
                return ResultBuilder.createUserErrorResult("Invalid region name");
            }
            if (lruEvictionAlgo != null || lruEvictionAction != null || lruEvictionLimit != null || concurrencyLevel != null || initialCapacity != null || loadFactor != null || compressorClassName != null || offHeap != null || statisticsEnabled != null) {
                if (!remove) {
                    String offHeapString;
                    String lruEvictionLimitString = lruEvictionLimit == null ? null : lruEvictionLimit.toString();
                    String concurrencyLevelString = concurrencyLevel == null ? null : concurrencyLevel.toString();
                    String initialCapacityString = initialCapacity == null ? null : initialCapacity.toString();
                    String loadFactorString = loadFactor == null ? null : loadFactor.toString();
                    String statisticsEnabledString = statisticsEnabled == null ? null : statisticsEnabled.toString();
                    String string = offHeapString = offHeap == null ? null : offHeap.toString();
                    if ("none".equals(compressorClassName)) {
                        compressorClassName = "";
                    }
                    String resultMessage = DiskStoreImpl.modifyRegion(diskStoreName, dirs, "/" + regionName, lruEvictionAlgo, lruEvictionAction, lruEvictionLimitString, concurrencyLevelString, initialCapacityString, loadFactorString, compressorClassName, statisticsEnabledString, offHeapString, false);
                    result = ResultBuilder.createInfoResult(resultMessage);
                } else {
                    result = ResultBuilder.createParsingErrorResult("Cannot use the --remove=true parameter with any other parameters");
                }
            } else if (remove) {
                DiskStoreImpl.destroyRegion(diskStoreName, dirs, "/" + regionName);
                result = ResultBuilder.createInfoResult("The region " + regionName + " was successfully removed from the disk store " + diskStoreName);
            } else {
                result = ResultBuilder.createParsingErrorResult("Please provide a relevant parameter");
            }
        }
        catch (IllegalArgumentException e) {
            String message = "Please check the parameters";
            message = message + "\n" + e.getMessage();
            result = ResultBuilder.createGemFireErrorResult(message);
        }
        catch (IllegalStateException e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        catch (CacheExistsException e) {
            result = ResultBuilder.createGemFireErrorResult("Cannot execute alter disk-store when a cache exists (Offline command)");
        }
        catch (Exception e) {
            result = this.createErrorResult(e.getMessage());
        }
        return result;
    }

    private Result createErrorResult(String message) {
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        erd.addLine(message);
        return ResultBuilder.buildResult(erd);
    }
}

