/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.CommandResponse;
import org.apache.geode.management.internal.cli.CommandResponseWriter;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;

public class CommandResponseBuilder {
    public static CommandResponse prepareCommandResponse(String memberName, CommandResult result) {
        GfJsonObject content = result.getContent();
        return new CommandResponse(memberName, CommandResponseBuilder.getType(result), result.getStatus().getCode(), "1/1", "__NULL__", CommandResponseBuilder.getDebugInfo(result), result.getHeader(), content, result.getFooter(), result.failedToPersist(), result.getFileToDownload());
    }

    public static CommandResponse prepareCommandResponseFromJson(String jsonString) {
        GfJsonObject jsonObject;
        try {
            jsonObject = new GfJsonObject(jsonString);
        }
        catch (GfJsonException e) {
            jsonObject = GfJsonObject.getGfJsonErrorObject(CliUtil.stackTraceAsString(e));
        }
        return new CommandResponse(jsonObject);
    }

    public static String getCommandResponseJson(CommandResponse commandResponse) {
        return new GfJsonObject(commandResponse).toString();
    }

    public static String createCommandResponseJson(String memberName, CommandResult result) {
        return CommandResponseBuilder.getCommandResponseJson(CommandResponseBuilder.prepareCommandResponse(memberName, result));
    }

    private static String getType(CommandResult result) {
        return result.getType();
    }

    private static String getDebugInfo(CommandResult result) {
        String debugInfo = "";
        if (CommandExecutionContext.isSetWrapperThreadLocal()) {
            CommandResponseWriter responseWriter = CommandExecutionContext.getCommandResponseWriter();
            debugInfo = responseWriter.getResponseWritten();
        }
        return debugInfo;
    }
}

