/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.exceptions.UserErrorException;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class CliUtil {
    public static final FileFilter JAR_FILE_FILTER = new CustomFileFilter(".jar");

    public static String cliDependenciesExist(boolean includeGfshDependencies) {
        String jarProductName = CliUtil.checkLibraryByLoadingClass("org.springframework.shell.core.Parser", "Spring Shell");
        jarProductName = CliUtil.checkLibraryByLoadingClass("org.springframework.shell.core.annotation.CliCommand", "Spring Shell");
        if (jarProductName != null) {
            return jarProductName;
        }
        jarProductName = CliUtil.checkLibraryByLoadingClass("org.springframework.core.SpringVersion", "Spring Core");
        if (jarProductName != null) {
            return jarProductName;
        }
        if (includeGfshDependencies && (jarProductName = CliUtil.checkLibraryByLoadingClass("jline.console.ConsoleReader", "JLine")) != null) {
            return jarProductName;
        }
        return jarProductName;
    }

    private static String checkLibraryByLoadingClass(String className, String jarProductName) {
        try {
            ClassPathLoader.getLatest().forName(className);
        }
        catch (ClassNotFoundException e) {
            return jarProductName;
        }
        return null;
    }

    public static InternalCache getCacheIfExists() {
        InternalCache cache;
        try {
            cache = CliUtil.getInternalCache();
        }
        catch (CacheClosedException e) {
            cache = null;
        }
        return cache;
    }

    public static Byte[][] filesToBytes(List<String> fileNames) throws IOException {
        ArrayList<byte[]> filesDataList = new ArrayList<byte[]>();
        for (String fileName : fileNames) {
            File file = new File(fileName);
            if (!file.exists()) {
                throw new FileNotFoundException("Could not find " + file.getCanonicalPath());
            }
            if (file.isDirectory()) {
                File[] childrenFiles;
                for (File childrenFile : childrenFiles = file.listFiles(JAR_FILE_FILTER)) {
                    filesDataList.add(childrenFile.getName().getBytes());
                    filesDataList.add(CliUtil.toByteArray(new FileInputStream(childrenFile)));
                }
                continue;
            }
            filesDataList.add(file.getName().getBytes());
            filesDataList.add(CliUtil.toByteArray(new FileInputStream(file)));
        }
        List convertedList = filesDataList.stream().map(ArrayUtils::toObject).collect(Collectors.toList());
        return (Byte[][])convertedList.toArray((T[])new Byte[convertedList.size()][]);
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int n = 0;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static List<String> bytesToFiles(Byte[][] fileData, String parentDirPath) throws IOException, UnsupportedOperationException {
        ArrayList<String> filesPaths = new ArrayList<String>();
        FileOutputStream fos = null;
        File file = null;
        File parentDir = new File(parentDirPath);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new UnsupportedOperationException("Couldn't create required directory structure for " + parentDirPath);
        }
        for (int i = 0; i < fileData.length; ++i) {
            byte[] bytes = ArrayUtils.toPrimitive((Byte[])fileData[i]);
            if (i % 2 == 0) {
                String fileName = new String(bytes);
                file = new File(parentDir, fileName);
                fos = new FileOutputStream(file);
                continue;
            }
            fos.write(bytes);
            fos.close();
            filesPaths.add(file.getAbsolutePath());
        }
        return filesPaths;
    }

    private static InternalCache getInternalCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public static Set<String> getAllRegionNames() {
        InternalCache cache = CliUtil.getInternalCache();
        HashSet<String> regionNames = new HashSet<String>();
        Set<Region<?, ?>> rootRegions = cache.rootRegions();
        for (Region<?, ?> rootRegion : rootRegions) {
            regionNames.add(rootRegion.getFullPath().substring(1));
            Set<Region<?, ?>> subRegions = rootRegion.subregions(true);
            for (Region<?, ?> subRegion : subRegions) {
                regionNames.add(subRegion.getFullPath().substring(1));
            }
        }
        return regionNames;
    }

    public static String convertStringSetToString(Set<String> stringSet, char delimiter) {
        StringBuilder sb = new StringBuilder();
        if (stringSet != null) {
            for (String stringValue : stringSet) {
                sb.append(stringValue);
                sb.append(delimiter);
            }
        }
        return sb.toString();
    }

    public static String convertStringListToString(List<String> stringList, char delimiter) {
        StringBuilder sb = new StringBuilder();
        if (stringList != null) {
            for (String stringValue : stringList) {
                sb.append(stringValue);
                sb.append(delimiter);
            }
        }
        return sb.toString();
    }

    public static Set<DistributedMember> findMembersIncludingLocators(String[] groups, String[] members) {
        InternalCache cache = CliUtil.getInternalCache();
        Set<DistributedMember> allMembers = CliUtil.getAllMembers(cache);
        return CliUtil.findMembers(allMembers, groups, members);
    }

    public static Set<DistributedMember> findMembers(String[] groups, String[] members) {
        InternalCache cache = CliUtil.getInternalCache();
        Set<DistributedMember> allNormalMembers = CliUtil.getAllNormalMembers(cache);
        return CliUtil.findMembers(allNormalMembers, groups, members);
    }

    private static Set<DistributedMember> findMembers(Set<DistributedMember> membersToConsider, String[] groups, String[] members) {
        if (groups == null) {
            groups = new String[]{};
        }
        if (members == null) {
            members = new String[]{};
        }
        if (members.length > 0 && groups.length > 0) {
            throw new UserErrorException("Please provide either \"member\" or \"group\" option.");
        }
        if (members.length == 0 && groups.length == 0) {
            return membersToConsider;
        }
        HashSet<DistributedMember> matchingMembers = new HashSet<DistributedMember>();
        for (String memberNameOrId : members) {
            for (DistributedMember member : membersToConsider) {
                if (!memberNameOrId.equalsIgnoreCase(member.getId()) && !memberNameOrId.equalsIgnoreCase(member.getName())) continue;
                matchingMembers.add(member);
            }
        }
        for (String group : groups) {
            for (DistributedMember member : membersToConsider) {
                if (!member.getGroups().contains(group)) continue;
                matchingMembers.add(member);
            }
        }
        return matchingMembers;
    }

    public static DistributedMember getDistributedMemberByNameOrId(String memberNameOrId) {
        DistributedMember memberFound = null;
        if (memberNameOrId != null) {
            InternalCache cache = CliUtil.getInternalCache();
            Set<DistributedMember> memberSet = CliUtil.getAllMembers(cache);
            for (DistributedMember member : memberSet) {
                if (!memberNameOrId.equalsIgnoreCase(member.getId()) && !memberNameOrId.equalsIgnoreCase(member.getName())) continue;
                memberFound = member;
                break;
            }
        }
        return memberFound;
    }

    public static String stackTraceAsString(Throwable e) {
        String stackAsString = "";
        if (e != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            e.printStackTrace(pw);
            stackAsString = writer.toString();
        }
        return stackAsString;
    }

    public static <K> Class<K> forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    public static <K> K newInstance(Class<K> klass, String neededFor) {
        K instance;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    public static Result getFunctionResult(ResultCollector<?, ?> rc, String commandName) {
        Object resultObj;
        List results = (List)rc.getResult();
        Result result = results != null ? ((resultObj = results.get(0)) instanceof String ? ResultBuilder.createInfoResult((String)resultObj) : (resultObj instanceof Exception ? ResultBuilder.createGemFireErrorResult(((Exception)resultObj).getMessage()) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)commandName)))) : ResultBuilder.createGemFireErrorResult(CliStrings.format("Error occurred while executing : {0}", (Object)commandName));
        return result;
    }

    public static Set<DistributedMember> getMembersWithAsyncEventQueue(InternalCache cache, String queueId) {
        Set<DistributedMember> members = CliUtil.findMembers(null, null);
        return members.stream().filter(m -> CliUtil.getAsyncEventQueueIds(cache, m).contains(queueId)).collect(Collectors.toSet());
    }

    public static Set<String> getAsyncEventQueueIds(InternalCache cache, DistributedMember member) {
        SystemManagementService managementService = (SystemManagementService)ManagementService.getExistingManagementService(cache);
        return managementService.getAsyncEventQueueMBeanNames(member).stream().map(x -> x.getKeyProperty("queue")).collect(Collectors.toSet());
    }

    public static DeflaterInflaterData compressBytes(byte[] input) {
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        compresser.finish();
        byte[] buffer = new byte[100];
        byte[] result = new byte[]{};
        int compressedDataLength = 0;
        int totalCompressedDataLength = 0;
        do {
            byte[] newResult = new byte[result.length + buffer.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            compressedDataLength = compresser.deflate(buffer);
            totalCompressedDataLength += compressedDataLength;
            System.arraycopy(buffer, 0, newResult, result.length, buffer.length);
            result = newResult;
        } while (compressedDataLength != 0);
        return new DeflaterInflaterData(totalCompressedDataLength, result);
    }

    public static DeflaterInflaterData uncompressBytes(byte[] output, int compressedDataLength) throws DataFormatException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(output, 0, compressedDataLength);
        byte[] buffer = new byte[512];
        byte[] result = new byte[]{};
        while (!decompresser.needsInput()) {
            int bytesRead = decompresser.inflate(buffer);
            byte[] newResult = new byte[result.length + bytesRead];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(buffer, 0, newResult, result.length, bytesRead);
            result = newResult;
        }
        decompresser.end();
        return new DeflaterInflaterData(result.length, result);
    }

    public static boolean contains(Object[] array, Object object) {
        boolean contains = false;
        if (array != null && object != null) {
            contains = Arrays.asList(array).contains(object);
        }
        return contains;
    }

    public static Set<DistributedMember> getAllNormalMembers(InternalCache cache) {
        return new HashSet<DistributedMember>(cache.getInternalDistributedSystem().getDistributionManager().getNormalDistributionManagerIds());
    }

    public static Set<DistributedMember> getAllMembers(InternalCache cache) {
        return CliUtil.getAllMembers(cache.getInternalDistributedSystem());
    }

    public static Set<DistributedMember> getAllMembers(InternalDistributedSystem internalDS) {
        return new HashSet<DistributedMember>(internalDS.getDistributionManager().getDistributionManagerIds());
    }

    public static ResultCollector<?, ?> executeFunction(Function function, Object args, Set<DistributedMember> targetMembers) {
        Execution execution = args != null ? FunctionService.onMembers(targetMembers).setArguments(args) : FunctionService.onMembers(targetMembers);
        ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        return execution.execute(function);
    }

    public static Set<DistributedMember> getRegionAssociatedMembers(String region, InternalCache cache, boolean returnAll) {
        DistributedRegionMXBean regionMXBean;
        if (region == null || region.isEmpty()) {
            return Collections.emptySet();
        }
        if (!region.startsWith("/")) {
            region = "/" + region;
        }
        if ((regionMXBean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(region)) == null) {
            return Collections.emptySet();
        }
        String[] regionAssociatedMemberNames = regionMXBean.getMembers();
        HashSet<DistributedMember> matchedMembers = new HashSet<DistributedMember>();
        HashSet<DistributedMember> allClusterMembers = new HashSet<DistributedMember>();
        allClusterMembers.addAll(cache.getMembers());
        allClusterMembers.add(cache.getDistributedSystem().getDistributedMember());
        for (DistributedMember member : allClusterMembers) {
            for (String regionAssociatedMemberName : regionAssociatedMemberNames) {
                String name = MBeanJMXAdapter.getMemberNameOrId(member);
                if (!name.equals(regionAssociatedMemberName)) continue;
                matchedMembers.add(member);
                if (returnAll) continue;
                return matchedMembers;
            }
        }
        return matchedMembers;
    }

    public static Set<DistributedMember> getQueryRegionsAssociatedMembers(Set<String> regions, InternalCache cache, boolean returnAll) {
        Set results = regions.stream().map(region -> CliUtil.getRegionAssociatedMembers(region, cache, true)).reduce((s1, s2) -> {
            s1.retainAll((Collection<?>)s2);
            return s1;
        }).get();
        if (returnAll || results.size() <= 1) {
            return results;
        }
        return Collections.singleton(results.iterator().next());
    }

    public static String getMemberNameOrId(DistributedMember distributedMember) {
        String nameOrId = null;
        if (distributedMember != null) {
            nameOrId = distributedMember.getName();
            nameOrId = nameOrId != null && !nameOrId.isEmpty() ? nameOrId : distributedMember.getId();
        }
        return nameOrId;
    }

    public static <T> String arrayToString(T[] array) {
        if (array == null) {
            return "null";
        }
        return Arrays.stream(array).map(String::valueOf).collect(Collectors.joining(", "));
    }

    public static String decodeWithDefaultCharSet(String urlToDecode) {
        try {
            return URLDecoder.decode(urlToDecode, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return urlToDecode;
        }
    }

    public static String resolvePathname(String pathname) {
        return StringUtils.isBlank((String)pathname) ? pathname : IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(pathname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLessCommandAsExternalViewer(Result commandResult, boolean isError) {
        StringBuilder sb = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (commandResult.hasNextLine()) {
            sb.append(commandResult.nextLine()).append(NEW_LINE);
        }
        File file = null;
        try {
            file = File.createTempFile("gfsh_output", "less");
            FileWriter fw = new FileWriter(file);
            fw.append(sb.toString());
            fw.close();
            File workingDir = file.getParentFile();
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "LESSOPEN=\"|color %s\" less -SR " + file.getName() + " < /dev/tty > /dev/tty "}, null, workingDir);
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            Gfsh.printlnErr(e.getMessage());
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public static String getClientIdFromCacheClientProxy(CacheClientProxy p) {
        if (p == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(p.getProxyID()).append(":port=").append(p.getRemotePort()).append(":primary=").append(p.isPrimary()).append("]");
        return buffer.toString();
    }

    public static class DeflaterInflaterData
    implements Serializable {
        private static final long serialVersionUID = 1104813333595216795L;
        private final int dataLength;
        private final byte[] data;

        public DeflaterInflaterData(int dataLength, byte[] data) {
            this.dataLength = dataLength;
            this.data = data;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return String.valueOf(this.dataLength);
        }
    }

    static class CustomFileFilter
    implements FileFilter {
        private String extensionWithDot;

        public CustomFileFilter(String extensionWithDot) {
            this.extensionWithDot = extensionWithDot;
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return name.endsWith(this.extensionWithDot);
        }
    }
}

