/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;

public class GCStatsMonitor
extends MBeanStatsMonitor {
    private volatile long collections = 0L;
    private volatile long collectionTime = 0L;

    public GCStatsMonitor(String name) {
        super(name);
    }

    @Override
    public Number getStatistic(String statName) {
        if (statName.equals("collections")) {
            return this.getCollections();
        }
        if (statName.equals("collectionTime")) {
            return this.getCollectionTime();
        }
        return 0;
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        this.decreasePrevValues(this.statsMap);
        for (StatisticId statId : notification) {
            Number value;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value = 0;
            }
            this.log(name, value);
            this.increaseStats(name, value);
            this.statsMap.put(name, value);
        }
    }

    private void decreasePrevValues(MBeanStatsMonitor.DefaultHashMap statsMap) {
        this.collections -= (long)statsMap.get("collections").intValue();
        this.collectionTime -= (long)statsMap.get("collectionTime").intValue();
    }

    private void increaseStats(String name, Number value) {
        if (name.equals("collections")) {
            this.collections += value.longValue();
            return;
        }
        if (name.equals("collectionTime")) {
            this.collectionTime += value.longValue();
            return;
        }
    }

    public long getCollections() {
        return this.collections;
    }

    public long getCollectionTime() {
        return this.collectionTime;
    }
}

