/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamMonitor;
import com.healthmarketscience.rmiio.RemoteOutputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteOutputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.beans.FileUploaderMBean;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class FileUploader
implements FileUploaderMBean {
    public static String STAGED_DIR_PREFIX = "uploaded-";
    private static Logger logger = LogService.getLogger();
    private RemoteStreamExporter exporter;

    public FileUploader(RemoteStreamExporter exporter) {
        this.exporter = exporter;
    }

    @Override
    public RemoteFile uploadFile(String filename) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        Path tempDir = Files.createTempDirectory(STAGED_DIR_PREFIX, PosixFilePermissions.asFileAttribute(perms));
        File stagedFile = new File(tempDir.toString(), filename);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(stagedFile));
        RemoteOutputStreamMonitor monitor = new RemoteOutputStreamMonitor(){

            public void closed(RemoteOutputStreamServer stream, boolean clean) {
                try {
                    stream.close(true);
                }
                catch (IOException e) {
                    logger.error("error closing RemoteOutputStreamServer", (Throwable)e);
                }
            }
        };
        SimpleRemoteOutputStream server = new SimpleRemoteOutputStream((OutputStream)bos, (RemoteStreamMonitor)monitor);
        RemoteOutputStream remoteStream = (RemoteOutputStream)this.exporter.export((RemoteStreamServer)server);
        RemoteFile remoteFile = new RemoteFile(stagedFile.getAbsolutePath(), remoteStream);
        return remoteFile;
    }

    @Override
    public void deleteFiles(List<String> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (String filename : files) {
            File file = new File(filename);
            File parent = file.getParentFile();
            if (!parent.getName().startsWith(STAGED_DIR_PREFIX)) {
                throw new GemFireSecurityException(String.format("Cannot delete %s, not in the uploaded directory.", filename));
            }
            FileUtils.deleteQuietly((File)file);
            FileUtils.deleteQuietly((File)parent);
        }
    }

    public static class RemoteFile
    implements Serializable {
        private String filename;
        private RemoteOutputStream outputStream;

        public RemoteFile(String filename, RemoteOutputStream outputStream) {
            this.filename = filename;
            this.outputStream = outputStream;
        }

        public String getFilename() {
            return this.filename;
        }

        public RemoteOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

