/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.geode.distributed.internal.tcpserver.LocatorCancelException;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.internal.JmxManagerLocatorResponse;

public class JmxManagerLocatorRequest
implements DataSerializableFixedID {
    private static final JmxManagerLocatorRequest SINGLETON = new JmxManagerLocatorRequest();

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }

    @Override
    public int getDSFID() {
        return 2150;
    }

    public String toString() {
        return "JmxManagerLocatorRequest";
    }

    public static JmxManagerLocatorResponse send(String locatorHost, int locatorPort, int msTimeout, Properties sslConfigProps) throws IOException, ClassNotFoundException {
        InetAddress networkAddress = InetAddress.getByName(locatorHost);
        InetSocketAddress inetSockAddr = new InetSocketAddress(networkAddress, locatorPort);
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(sslConfigProps, SecurableCommunicationChannel.LOCATOR);
        SocketCreator socketCreator = new SocketCreator(sslConfig);
        TcpClient client = new TcpClient(socketCreator);
        Object responseFromServer = client.requestToServer(inetSockAddr, SINGLETON, msTimeout, true);
        if (responseFromServer instanceof JmxManagerLocatorResponse) {
            return (JmxManagerLocatorResponse)responseFromServer;
        }
        throw new LocatorCancelException("Unrecognisable response received: This could be the result of trying to connect a non-SSL-enabled client to an SSL-enabled locator.");
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

