/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.JmxManagerAdvisee;
import org.apache.logging.log4j.Logger;

public class JmxManagerAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();

    private JmxManagerAdvisor(DistributionAdvisee advisee) {
        super(advisee);
        JmxManagerProfile p = new JmxManagerProfile(this.getDistributionManager().getId(), this.incrementAndGetVersion());
        advisee.fillInProfile(p);
        ((JmxManagerAdvisee)advisee).initProfile(p);
    }

    public static JmxManagerAdvisor createJmxManagerAdvisor(DistributionAdvisee advisee) {
        JmxManagerAdvisor advisor = new JmxManagerAdvisor(advisee);
        advisor.initialize();
        return advisor;
    }

    public String toString() {
        return "JmxManagerAdvisor for " + this.getAdvisee();
    }

    public void broadcastChange() {
        try {
            Set<InternalDistributedMember> recips = this.adviseGeneric();
            JmxManagerProfile p = new JmxManagerProfile(this.getDistributionManager().getId(), this.incrementAndGetVersion());
            this.getAdvisee().fillInProfile(p);
            JmxManagerProfileMessage.send(this.getAdvisee().getSystem().getDistributionManager(), recips, p);
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    public List<JmxManagerProfile> adviseAlreadyManaging() {
        return this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof JmxManagerProfile);
                JmxManagerProfile jmxProfile = (JmxManagerProfile)profile;
                return jmxProfile.isJmxManagerRunning();
            }
        });
    }

    public List<JmxManagerProfile> adviseWillingToManage() {
        return this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof JmxManagerProfile);
                JmxManagerProfile jmxProfile = (JmxManagerProfile)profile;
                return jmxProfile.isJmxManager();
            }
        });
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new JmxManagerProfile(memberId, version);
    }

    @Override
    protected List fetchProfiles(DistributionAdvisor.Filter f) {
        this.initializationGate();
        List<JmxManagerProfile> result = null;
        JmxManagerAdvisee advisee = (JmxManagerAdvisee)this.getAdvisee();
        JmxManagerProfile myp = advisee.getMyMostRecentProfile();
        if (f == null || f.include(myp)) {
            if (result == null) {
                result = new ArrayList<JmxManagerProfile>();
            }
            result.add(myp);
        }
        DistributionAdvisor.Profile[] locProfiles = this.profiles;
        for (int i = 0; i < locProfiles.length; ++i) {
            DistributionAdvisor.Profile profile = locProfiles[i];
            if (f != null && !f.include(profile)) continue;
            if (result == null) {
                result = new ArrayList(locProfiles.length);
            }
            result.add((JmxManagerProfile)profile);
        }
        result = result == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(result);
        return result;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    public static class JmxManagerProfile
    extends DistributionAdvisor.Profile {
        private boolean jmxManager;
        private String host;
        private int port;
        private boolean ssl;
        private boolean started;

        public JmxManagerProfile() {
        }

        public boolean isJmxManager() {
            return this.jmxManager;
        }

        public boolean isJmxManagerRunning() {
            return this.started;
        }

        public void setInfo(boolean jmxManager2, String host2, int port2, boolean ssl2, boolean started2) {
            this.jmxManager = jmxManager2;
            this.host = host2;
            this.port = port2;
            this.ssl = ssl2;
            this.started = started2;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean getSsl() {
            return this.ssl;
        }

        public JmxManagerProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("JmxManagerAdvisor.JmxManagerProfile");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            JmxManagerProfile jmxManagerProfile = this;
            synchronized (jmxManagerProfile) {
                if (this.jmxManager) {
                    sb.append("; jmxManager");
                }
                sb.append("; host=").append(this.host).append("; port=").append(this.port);
                if (this.ssl) {
                    sb.append("; ssl");
                }
                if (this.started) {
                    sb.append("; started");
                }
            }
        }

        @Override
        public void processIncoming(DistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            InternalCache cache = dm.getCache();
            if (cache != null && !cache.isClosed()) {
                this.handleDistributionAdvisee(cache.getJmxManagerAdvisor().getAdvisee(), removeProfile, exchangeProfiles, replyProfiles);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.jmxManager = DataSerializer.readPrimitiveBoolean(in);
            this.host = DataSerializer.readString(in);
            this.port = DataSerializer.readPrimitiveInt(in);
            this.ssl = DataSerializer.readPrimitiveBoolean(in);
            this.started = DataSerializer.readPrimitiveBoolean(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toData(DataOutput out) throws IOException {
            boolean tmpStarted;
            boolean tmpSsl;
            int tmpPort;
            String tmpHost;
            boolean tmpJmxManager;
            JmxManagerProfile jmxManagerProfile = this;
            synchronized (jmxManagerProfile) {
                tmpJmxManager = this.jmxManager;
                tmpHost = this.host;
                tmpPort = this.port;
                tmpSsl = this.ssl;
                tmpStarted = this.started;
            }
            super.toData(out);
            DataSerializer.writePrimitiveBoolean(tmpJmxManager, out);
            DataSerializer.writeString(tmpHost, out);
            DataSerializer.writePrimitiveInt(tmpPort, out);
            DataSerializer.writePrimitiveBoolean(tmpSsl, out);
            DataSerializer.writePrimitiveBoolean(tmpStarted, out);
        }

        @Override
        public int getDSFID() {
            return 153;
        }
    }

    public static class JmxManagerProfileMessage
    extends HighPriorityDistributionMessage {
        private volatile JmxManagerProfile profile;
        private volatile int processorId;

        public JmxManagerProfileMessage() {
        }

        @Override
        public boolean sendViaUDP() {
            return true;
        }

        private JmxManagerProfileMessage(Set<InternalDistributedMember> recips, JmxManagerProfile p) {
            this.setRecipients(recips);
            this.processorId = 0;
            this.profile = p;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void process(DistributionManager dm) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int getDSFID() {
            return 154;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.profile = (JmxManagerProfile)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            DataSerializer.writeObject(this.profile, out);
        }

        public static void send(DM dm, Set<InternalDistributedMember> recips, JmxManagerProfile profile) {
            JmxManagerProfileMessage r = new JmxManagerProfileMessage(recips, profile);
            dm.putOutgoing(r);
        }

        @Override
        public String getShortClassName() {
            return "JmxManagerProfileMessage";
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getShortClassName()).append(" (processorId=").append(this.processorId).append("; profile=").append(this.profile);
            sb.append(")");
            return sb.toString();
        }
    }
}

