/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogFileParser;

public class SortLogFile {
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    public static void sortLogFile(InputStream logFile, PrintWriter sortedFile) throws IOException {
        TreeSet<LogFileParser.LogEntry> sorted = new TreeSet<LogFileParser.LogEntry>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String stamp2;
                LogFileParser.LogEntry entry1 = (LogFileParser.LogEntry)o1;
                LogFileParser.LogEntry entry2 = (LogFileParser.LogEntry)o2;
                String stamp1 = entry1.getTimestamp();
                if (stamp1.equals(stamp2 = entry2.getTimestamp())) {
                    if (entry1.getContents().equals(entry2.getContents())) {
                        return Integer.valueOf(entry1.hashCode()).compareTo(entry2.hashCode());
                    }
                    return entry1.getContents().compareTo(entry2.getContents());
                }
                return stamp1.compareTo(stamp2);
            }
        });
        BufferedReader br = new BufferedReader(new InputStreamReader(logFile));
        LogFileParser parser = new LogFileParser(null, br);
        while (parser.hasMoreEntries()) {
            sorted.add(parser.getNextEntry());
        }
        for (LogFileParser.LogEntry entry : sorted) {
            entry.writeTo(sortedFile);
        }
    }

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println(LocalizedStrings.SortLogFile_USAGE.toLocalizedString() + ": java SortLogFile logFile");
        err.println("-sortedFile file " + LocalizedStrings.SortLogFile_FILE_IN_WHICH_TO_PUT_SORTED_LOG.toLocalizedString());
        err.println("");
        err.println(LocalizedStrings.SortLogFile_SORTS_A_GEMFIRE_LOG_FILE_BY_TIMESTAMP_THE_MERGED_LOG_FILE_IS_WRITTEN_TO_SYSTEM_OUT_OR_A_FILE.toLocalizedString());
        err.println("");
        ExitCode.FATAL.doSystemExit();
    }

    public static void main(String[] args) throws IOException {
        File logFile = null;
        File sortedFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-sortedFile")) {
                if (++i >= args.length) {
                    SortLogFile.usage("Missing sorted file name");
                }
                sortedFile = new File(args[i]);
                continue;
            }
            if (logFile == null) {
                File file = new File(args[i]);
                if (!file.exists()) {
                    SortLogFile.usage(LocalizedStrings.SortLogFile_FILE_0_DOES_NOT_EXIST.toLocalizedString(file));
                }
                logFile = file;
                continue;
            }
            SortLogFile.usage(LocalizedStrings.SortLogFile_EXTRANEOUS_COMMAND_LINE_0.toLocalizedString(args[i]));
        }
        if (logFile == null) {
            SortLogFile.usage(LocalizedStrings.SortLogFile_MISSING_FILENAME.toLocalizedString());
        }
        FileInputStream logFileStream = new FileInputStream(logFile);
        PrintStream ps = sortedFile != null ? new PrintStream(new FileOutputStream(sortedFile), true) : out;
        PrintWriter pw = new PrintWriter(ps, true);
        SortLogFile.sortLogFile(logFileStream, pw);
        ExitCode.NORMAL.doSystemExit();
    }
}

