/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

import java.util.Optional;
import org.apache.geode.annotations.Experimental;

public class SystemPropertyHelper {
    private static final String GEODE_PREFIX = "geode.";
    private static final String GEMFIRE_PREFIX = "gemfire.";
    @Experimental
    public static final String EVICTION_SCAN_ASYNC = "EvictionScanAsync";
    @Experimental
    public static final String EVICTION_SCAN_MAX_THREADS = "EvictionScanMaxThreads";
    @Experimental
    public static final String EVICTION_SCAN_THRESHOLD_PERCENT = "EvictionScanThresholdPercent";
    public static final String EVICTION_SEARCH_MAX_ENTRIES = "lru.maxSearchEntries";

    public static boolean getProductBooleanProperty(String name) {
        String property = System.getProperty(GEODE_PREFIX + name);
        if (property != null) {
            return Boolean.getBoolean(GEODE_PREFIX + name);
        }
        return Boolean.getBoolean(GEMFIRE_PREFIX + name);
    }

    public static Optional<Integer> getProductIntegerProperty(String name) {
        Integer propertyValue = Integer.getInteger(GEODE_PREFIX + name);
        if (propertyValue == null) {
            propertyValue = Integer.getInteger(GEMFIRE_PREFIX + name);
        }
        if (propertyValue != null) {
            return Optional.of(propertyValue);
        }
        return Optional.empty();
    }

    public static boolean restoreSetOperationTransactionBehavior() {
        return SystemPropertyHelper.getProductBooleanProperty("restoreSetOperationTransactionBehavior");
    }

    public static boolean restoreIdleExpirationBehavior() {
        return SystemPropertyHelper.getProductBooleanProperty("restoreIdleExpirationBehavior");
    }
}

