/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GatewayReceiverCreation
implements GatewayReceiver {
    private static final Logger logger = LogService.getLogger();
    private Cache cache;
    private String host;
    private int startPort;
    private int endPort;
    private String portRange;
    private List<GatewayTransportFilter> transFilter = new ArrayList<GatewayTransportFilter>();
    private int maxTimeBetweenPings;
    private int socketBufferSize;
    private String bindAddress;
    private String hostnameForSenders;
    private boolean manualStart;
    private CacheServer receiver;

    public GatewayReceiverCreation(Cache cache, int startPort, int endPort, int timeBetPings, int buffSize, String bindAdd, List<GatewayTransportFilter> filters, String hostnameForSenders, boolean manualStart) {
        this.cache = cache;
        this.startPort = startPort;
        this.endPort = endPort;
        this.maxTimeBetweenPings = timeBetPings;
        this.socketBufferSize = buffSize;
        this.bindAddress = bindAdd;
        this.hostnameForSenders = hostnameForSenders;
        this.transFilter = filters;
        this.manualStart = manualStart;
    }

    @Override
    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.transFilter;
    }

    @Override
    public int getMaximumTimeBetweenPings() {
        return this.maxTimeBetweenPings;
    }

    @Override
    public int getPort() {
        return this.startPort;
    }

    public String getPortRange() {
        return this.portRange;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setMaximumTimeBetweenPings(int time) {
        this.maxTimeBetweenPings = time;
    }

    public void setStartPort(int port) {
        this.startPort = port;
    }

    public void setEndPort(int port) {
        this.endPort = port;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    @Override
    public String getHostnameForSenders() {
        return this.hostnameForSenders;
    }

    @Override
    public String getHost() {
        throw new IllegalStateException("getHost should not be invoked on GatewayReceiverCreation");
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String address) {
        this.bindAddress = address;
    }

    @Override
    public void start() throws IOException {
        if (this.receiver == null) {
            this.receiver = ((CacheCreation)this.cache).addCacheServer(true);
            this.receiver.setPort(this.endPort + 1);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    public void addGatewayTransportFilter(GatewayTransportFilter filter) {
        this.transFilter.add(filter);
    }

    @Override
    public int getStartPort() {
        return this.startPort;
    }

    @Override
    public int getEndPort() {
        return this.endPort;
    }

    @Override
    public boolean isManualStart() {
        return this.manualStart;
    }

    @Override
    public CacheServer getServer() {
        return null;
    }
}

