/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.WaitForViewInstallation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.FindRemoteTXMessage;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PeerTXStateStub;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class TXFailoverCommand
extends BaseCommand {
    private static final Command singleton = new TXFailoverCommand();

    public static Command getCommand() {
        return singleton;
    }

    private TXFailoverCommand() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        serverConnection.setAsTrue(2);
        InternalDistributedMember client = (InternalDistributedMember)serverConnection.getProxyID().getDistributedMember();
        int uniqId = clientMessage.getTransactionId();
        if (logger.isDebugEnabled()) {
            logger.debug("TX: Transaction {} from {} is failing over to this server", (Object)uniqId, (Object)client);
        }
        TXId txId = this.createTXId(client, uniqId);
        TXManagerImpl mgr = (TXManagerImpl)serverConnection.getCache().getCacheTransactionManager();
        mgr.waitForCompletingTransaction(txId);
        if (mgr.isHostedTxRecentlyCompleted(txId)) {
            this.writeReply(clientMessage, serverConnection);
            serverConnection.setAsTrue(1);
            mgr.removeHostedTXState(txId);
            return;
        }
        boolean wasInProgress = mgr.setInProgress(true);
        TXStateProxy tx = mgr.getTXState();
        Assert.assertTrue(tx != null);
        if (!tx.isRealDealLocal()) {
            FindRemoteTXMessage.FindRemoteTXMessageReplyProcessor processor = FindRemoteTXMessage.send(serverConnection.getCache(), txId);
            try {
                processor.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                e.handleAsUnexpected();
            }
            InternalDistributedMember hostingMember = processor.getHostingMember();
            if (hostingMember != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TX: txState is not local, bootstrapping PeerTXState stub for targetNode: {}", (Object)hostingMember);
                }
                if (tx.getTarget() == null) {
                    tx.setTarget(hostingMember);
                }
                tx.setLocalTXState(new PeerTXStateStub(tx, hostingMember, client));
            } else {
                InternalCache cache = serverConnection.getCache();
                try {
                    WaitForViewInstallation.send((DistributionManager)cache.getDistributionManager());
                }
                catch (InterruptedException e) {
                    cache.getDistributionManager().getCancelCriterion().checkCancelInProgress(e);
                    Thread.currentThread().interrupt();
                }
                if (processor.getTxCommitMessage() != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("TX: for txId: {} rebuilt a recently completed tx", (Object)txId);
                    }
                    mgr.saveTXCommitMessageForClientFailover(txId, processor.getTxCommitMessage());
                } else {
                    TXFailoverCommand.writeException(clientMessage, new TransactionDataNodeHasDepartedException("Could not find transaction host for " + txId), false, serverConnection);
                    serverConnection.setAsTrue(1);
                    mgr.removeHostedTXState(txId);
                    return;
                }
            }
        }
        if (!wasInProgress) {
            mgr.setInProgress(false);
        }
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
    }

    TXId createTXId(InternalDistributedMember client, int uniqId) {
        return new TXId(client, uniqId);
    }
}

