/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender65;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;

public class ExecuteRegionFunctionSingleHop
extends BaseCommand {
    private static final ExecuteRegionFunctionSingleHop singleton = new ExecuteRegionFunctionSingleHop();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteRegionFunctionSingleHop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        block64: {
            int functionTimeout;
            CachedRegionHelper crHelper;
            HashSet<Object> removedNodesSet;
            byte functionState;
            byte hasResult;
            HashSet<Integer> buckets;
            HashSet<Object> filter;
            byte isExecuteOnAllBuckets;
            MemberMappedArgument memberMappedArg;
            Object args;
            Object function;
            String regionName;
            block63: {
                regionName = null;
                function = null;
                args = null;
                memberMappedArg = null;
                isExecuteOnAllBuckets = 0;
                filter = null;
                buckets = null;
                hasResult = 0;
                functionState = 0;
                int removedNodesSize = 0;
                removedNodesSet = null;
                int filterSize = 0;
                int bucketIdsSize = 0;
                int partNumber = 0;
                crHelper = serverConnection.getCachedRegionHelper();
                functionTimeout = 0;
                try {
                    Object obj;
                    byte[] bytes = clientMessage.getPart(0).getSerializedForm();
                    functionState = bytes[0];
                    if (bytes.length >= 5 && serverConnection.getClientVersion().ordinal() >= Version.GFE_8009.ordinal()) {
                        functionTimeout = Part.decodeInt(bytes, 1);
                    }
                    if ((hasResult = functionState != 1 ? (byte)((functionState & 2) - 1) : functionState) == 1) {
                        serverConnection.setAsTrue(2);
                        serverConnection.setAsTrue(3);
                    }
                    regionName = clientMessage.getPart(1).getString();
                    function = clientMessage.getPart(2).getStringOrObject();
                    args = clientMessage.getPart(3).getObject();
                    Part part = clientMessage.getPart(4);
                    if (part != null && (obj = part.getObject()) instanceof MemberMappedArgument) {
                        memberMappedArg = (MemberMappedArgument)obj;
                    }
                    if ((isExecuteOnAllBuckets = clientMessage.getPart(5).getSerializedForm()[0]) == 1) {
                        filter = new HashSet<Object>();
                        bucketIdsSize = clientMessage.getPart(6).getInt();
                        if (bucketIdsSize != 0) {
                            buckets = new HashSet<Integer>();
                            partNumber = 7;
                            for (int i = 0; i < bucketIdsSize; ++i) {
                                buckets.add(clientMessage.getPart(partNumber + i).getInt());
                            }
                        }
                        partNumber = 7 + bucketIdsSize;
                    } else {
                        filterSize = clientMessage.getPart(6).getInt();
                        if (filterSize != 0) {
                            filter = new HashSet();
                            partNumber = 7;
                            for (int i = 0; i < filterSize; ++i) {
                                filter.add(clientMessage.getPart(partNumber + i).getStringOrObject());
                            }
                        }
                        partNumber = 7 + filterSize;
                    }
                    removedNodesSize = clientMessage.getPart(partNumber).getInt();
                    if (removedNodesSize != 0) {
                        removedNodesSet = new HashSet<Object>();
                        ++partNumber;
                        for (int i = 0; i < removedNodesSize; ++i) {
                            removedNodesSet.add(clientMessage.getPart(partNumber + i).getStringOrObject());
                        }
                    }
                }
                catch (ClassNotFoundException exception) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)exception);
                    if (hasResult != true) break block63;
                    ExecuteRegionFunctionSingleHop.writeChunkedException(clientMessage, exception, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
            }
            if (function == null || regionName == null) {
                String message = null;
                if (function == null) {
                    message = LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("function");
                }
                if (regionName == null) {
                    message = LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("region");
                }
                logger.warn("{}: {}", (Object)serverConnection.getName(), message);
                this.sendError(hasResult, clientMessage, message, serverConnection);
                return;
            }
            Region region = crHelper.getRegion(regionName);
            if (region == null) {
                String message = LocalizedStrings.ExecuteRegionFunction_THE_REGION_NAMED_0_WAS_NOT_FOUND_DURING_EXECUTE_FUNCTION_REQUEST.toLocalizedString(regionName);
                logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                this.sendError(hasResult, clientMessage, message, serverConnection);
                return;
            }
            HandShake handShake = (HandShake)serverConnection.getHandshake();
            int earlierClientReadTimeout = handShake.getClientReadTimeout();
            handShake.setClientReadTimeout(functionTimeout);
            ServerToClientFunctionResultSender resultSender = null;
            Function functionObject = null;
            try {
                if (function instanceof String) {
                    functionObject = FunctionService.getFunction((String)function);
                    if (functionObject == null) {
                        String message = LocalizedStrings.ExecuteRegionFunction_THE_FUNCTION_0_HAS_NOT_BEEN_REGISTERED.toLocalizedString(function);
                        logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                        this.sendError(hasResult, clientMessage, message, serverConnection);
                        return;
                    }
                    byte functionStateOnServer = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
                    if (functionStateOnServer != functionState) {
                        String message = LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(function);
                        logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                        this.sendError(hasResult, clientMessage, message, serverConnection);
                        return;
                    }
                } else {
                    functionObject = (Function)function;
                }
                functionObject.getRequiredPermissions(regionName).forEach(securityService::authorize);
                AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
                String functionName = functionObject.getId();
                String regionPath = region.getFullPath();
                ExecuteFunctionOperationContext executeContext = null;
                if (authzRequest != null) {
                    executeContext = authzRequest.executeFunctionAuthorize(functionName, regionPath, filter, args, functionObject.optimizeForWrite());
                }
                AbstractExecution execution = (AbstractExecution)FunctionService.onRegion(region);
                ChunkedMessage m = serverConnection.getFunctionResponseMessage();
                m.setTransactionId(clientMessage.getTransactionId());
                resultSender = new ServerToClientFunctionResultSender65(m, 60, serverConnection, functionObject, executeContext);
                if (isExecuteOnAllBuckets == 1) {
                    PartitionedRegion pr = (PartitionedRegion)region;
                    Set<Integer> actualBucketSet = pr.getRegionAdvisor().getBucketSet();
                    try {
                        buckets.retainAll(actualBucketSet);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    if (buckets.isEmpty()) {
                        throw new FunctionException("Buckets are null");
                    }
                    execution = new PartitionedRegionFunctionExecutor((PartitionedRegion)region, buckets, args, memberMappedArg, resultSender, removedNodesSet, true, true);
                } else {
                    execution = new PartitionedRegionFunctionExecutor((PartitionedRegion)region, filter, args, memberMappedArg, resultSender, removedNodesSet, false, true);
                }
                if (hasResult == 1 && filter != null && filter.size() == 1) {
                    ServerConnection.executeFunctionOnLocalNodeOnly((byte)1);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function: {} on Server: {} with Execution: {}", (Object)functionObject.getId(), (Object)serverConnection, (Object)execution);
                }
                if (hasResult == 1) {
                    if (function instanceof String) {
                        switch (functionState) {
                            case 2: {
                                execution.execute((String)function).getResult();
                                break;
                            }
                            case 3: {
                                execution.execute((String)function).getResult();
                                break;
                            }
                            case 7: {
                                execution.execute((String)function).getResult();
                                break;
                            }
                            case 6: {
                                execution.execute((String)function).getResult();
                            }
                        }
                    } else {
                        execution.execute(functionObject).getResult();
                    }
                } else if (function instanceof String) {
                    switch (functionState) {
                        case 0: {
                            execution.execute((String)function);
                            break;
                        }
                        case 4: {
                            execution.execute((String)function);
                        }
                    }
                } else {
                    execution.execute(functionObject);
                }
            }
            catch (IOException ioe) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)ioe);
                String message = LocalizedStrings.ExecuteRegionFunction_SERVER_COULD_NOT_SEND_THE_REPLY.toLocalizedString();
                this.sendException(hasResult, clientMessage, message, serverConnection, ioe);
            }
            catch (FunctionException fe) {
                String message = fe.getMessage();
                if (fe.getCause() instanceof FunctionInvocationTargetException) {
                    if (functionObject.isHA() && logger.isDebugEnabled()) {
                        logger.debug("Exception on server while executing function: {}: {}", function, (Object)message);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Exception on server while executing function: {}: {}", function, (Object)message, (Object)fe);
                    }
                    Message message2 = clientMessage;
                    synchronized (message2) {
                        resultSender.setException(fe);
                        break block64;
                    }
                }
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)fe);
                this.sendException(hasResult, clientMessage, message, serverConnection, fe);
            }
            catch (Exception e) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)e);
                String message = e.getMessage();
                this.sendException(hasResult, clientMessage, message, serverConnection, e);
            }
            finally {
                handShake.setClientReadTimeout(earlierClientReadTimeout);
                ServerConnection.executeFunctionOnLocalNodeOnly((byte)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(byte hasResult, Message msg, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunctionSingleHop.writeFunctionResponseException(msg, 2, message, serverConnection, e);
                serverConnection.setAsTrue(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(byte hasResult, Message msg, String message, ServerConnection serverConnection) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunctionSingleHop.writeFunctionResponseError(msg, 61, message, serverConnection);
                serverConnection.setAsTrue(1);
            }
        }
    }

    protected static void writeFunctionResponseException(Message origMsg, int messageType2, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        ChunkedMessage functionResponseMsg = serverConnection.getFunctionResponseMessage();
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        int numParts = 0;
        if (functionResponseMsg.headerHasBeenSent()) {
            if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
                functionResponseMsg.setNumberOfParts(3);
                functionResponseMsg.addObjPart(e);
                functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
                functionResponseMsg.addObjPart(fe.getFailedNodeSet());
                numParts = 3;
            } else {
                functionResponseMsg.setNumberOfParts(2);
                functionResponseMsg.addObjPart(e);
                functionResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                numParts = 2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk while reply in progress: ", (Object)serverConnection.getName(), (Object)e);
            }
            functionResponseMsg.setServerConnection(serverConnection);
            functionResponseMsg.setLastChunkAndNumParts(true, numParts);
            functionResponseMsg.sendChunk(serverConnection);
        } else {
            chunkedResponseMsg.setMessageType(messageType2);
            chunkedResponseMsg.setTransactionId(origMsg.getTransactionId());
            chunkedResponseMsg.sendHeader();
            if (e instanceof FunctionException && e.getCause() instanceof InternalFunctionInvocationTargetException) {
                chunkedResponseMsg.setNumberOfParts(3);
                chunkedResponseMsg.addObjPart(e);
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                InternalFunctionInvocationTargetException fe = (InternalFunctionInvocationTargetException)e.getCause();
                chunkedResponseMsg.addObjPart(fe.getFailedNodeSet());
                numParts = 3;
            } else {
                chunkedResponseMsg.setNumberOfParts(2);
                chunkedResponseMsg.addObjPart(e);
                chunkedResponseMsg.addStringPart(BaseCommand.getExceptionTrace(e));
                numParts = 2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sending exception chunk: ", (Object)serverConnection.getName(), (Object)e);
            }
            chunkedResponseMsg.setServerConnection(serverConnection);
            chunkedResponseMsg.setLastChunkAndNumParts(true, numParts);
            chunkedResponseMsg.sendChunk(serverConnection);
        }
    }
}

