/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class ClientReady
extends BaseCommand {
    private static final ClientReady singleton = new ClientReady();

    public static Command getCommand() {
        return singleton;
    }

    private ClientReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        CacheServerStats stats = serverConnection.getCacheServerStats();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadClientReadyRequestTime(start - oldStart);
        try {
            String clientHost = serverConnection.getSocketHost();
            int clientPort = serverConnection.getSocketPort();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received client ready request ({} bytes) from {} on {}:{}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getProxyID(), (Object)clientHost, (Object)clientPort);
            }
            serverConnection.getAcceptor().getCacheClientNotifier().readyForEvents(serverConnection.getProxyID());
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessClientReadyTime(start - oldStart2);
            this.writeReply(clientMessage, serverConnection);
            serverConnection.setAsTrue(1);
            if (logger.isDebugEnabled()) {
                logger.debug(serverConnection.getName() + ": Processed client ready request from " + serverConnection.getProxyID() + " on " + clientHost + ":" + clientPort);
            }
        }
        finally {
            stats.incWriteClientReadyResponseTime(DistributionStats.getStatTime() - start);
        }
    }
}

