/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientInterestMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;

public class ServerInterestRegistrationMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private ClientProxyMembershipID clientId;
    private ClientInterestMessageImpl clientMessage;
    private int processorId;

    ServerInterestRegistrationMessage(ClientProxyMembershipID clientId, ClientInterestMessageImpl clientInterestMessage) {
        this.clientId = clientId;
        this.clientMessage = clientInterestMessage;
    }

    public ServerInterestRegistrationMessage() {
    }

    static void sendInterestChange(DM dm, ClientProxyMembershipID clientId, ClientInterestMessageImpl clientInterestMessage) {
        ServerInterestRegistrationMessage registrationMessage = new ServerInterestRegistrationMessage(clientId, clientInterestMessage);
        Set recipients = dm.getOtherDistributionManagerIds();
        registrationMessage.setRecipients(recipients);
        ReplyProcessor21 replyProcessor = new ReplyProcessor21(dm, (Collection)recipients);
        registrationMessage.processorId = replyProcessor.getProcessorId();
        dm.putOutgoing(registrationMessage);
        try {
            replyProcessor.waitForReplies();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(DistributionManager dm) {
        try {
            CacheClientProxy proxy;
            CacheClientNotifier clientNotifier = CacheClientNotifier.getInstance();
            if (clientNotifier != null && (proxy = clientNotifier.getClientProxy(this.clientId)) != null) {
                proxy.processInterestMessage(this.clientMessage);
            }
        }
        finally {
            ReplyMessage reply = new ReplyMessage();
            reply.setProcessorId(this.processorId);
            reply.setRecipient(this.getSender());
            try {
                dm.putOutgoing(reply);
            }
            catch (CancelException cancelException) {}
        }
    }

    @Override
    public int getDSFID() {
        return -117;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        InternalDataSerializer.invokeToData(this.clientId, out);
        InternalDataSerializer.invokeToData(this.clientMessage, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.clientId = new ClientProxyMembershipID();
        InternalDataSerializer.invokeFromData(this.clientId, in);
        this.clientMessage = new ClientInterestMessageImpl();
        InternalDataSerializer.invokeFromData(this.clientMessage, in);
    }
}

