/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.Principal;
import java.util.Properties;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.IncompatibleVersionException;
import org.apache.geode.cache.UnsupportedVersionException;
import org.apache.geode.cache.VersionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataStream;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.AuthorizeRequestPP;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.shiro.subject.Subject;

public class ServerHandShakeProcessor {
    private static final Logger logger = LogService.getLogger();
    protected static final byte REPLY_REFUSED = 60;
    protected static final byte REPLY_INVALID = 61;
    public static Version currentServerVersion = Acceptor.VERSION;

    public static void setSeverVersionForTesting(short ver) {
        currentServerVersion = Version.fromOrdinalOrCurrent(ver);
    }

    public static boolean readHandShake(ServerConnection connection, SecurityService securityService) {
        boolean validHandShake = false;
        Version clientVersion = null;
        try {
            clientVersion = ServerHandShakeProcessor.readClientVersion(connection);
        }
        catch (IOException e) {
            if (connection.getAcceptor().isRunning()) {
                logger.warn("{} {}", (Object)connection.getName(), (Object)e.getMessage(), (Object)e);
            }
            connection.stats.incFailedConnectionAttempts();
            connection.cleanup();
            validHandShake = false;
        }
        catch (UnsupportedVersionException uve) {
            logger.warn("{} {}", (Object)connection.getName(), (Object)uve.getMessage(), (Object)uve);
            connection.refuseHandshake(uve.getMessage(), (byte)60);
            connection.stats.incFailedConnectionAttempts();
            connection.cleanup();
            validHandShake = false;
        }
        catch (Exception e) {
            logger.warn("{} {}", (Object)connection.getName(), (Object)e.getMessage(), (Object)e);
            connection.refuseHandshake(LocalizedStrings.ServerHandShakeProcessor_0_SERVERS_CURRENT_VERSION_IS_1.toLocalizedString(e.getMessage(), Acceptor.VERSION.toString()), (byte)60);
            connection.stats.incFailedConnectionAttempts();
            connection.cleanup();
            validHandShake = false;
        }
        if (clientVersion != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Client version: {}", (Object)clientVersion);
            }
            if (clientVersion.compareTo(Version.GFE_57) >= 0) {
                validHandShake = ServerHandShakeProcessor.readGFEHandshake(connection, clientVersion, securityService);
            } else {
                connection.refuseHandshake("Unsupported version " + clientVersion + "Server's current version " + Acceptor.VERSION, (byte)60);
            }
        }
        return validHandShake;
    }

    public static void refuse(OutputStream out, String message) throws IOException {
        ServerHandShakeProcessor.refuse(out, message, (byte)60);
    }

    public static void refuse(OutputStream out, String message, byte exception) throws IOException {
        HeapDataOutputStream hdos = new HeapDataOutputStream(32, Version.CURRENT);
        DataOutputStream dos = new DataOutputStream(hdos);
        dos.writeByte(exception);
        dos.writeByte(0);
        dos.writeInt(0);
        InternalDistributedMember member = InternalDistributedSystem.getAnyInstance().getDistributedMember();
        ServerHandShakeProcessor.writeServerMember(member, dos);
        if (message == null) {
            message = "";
        }
        dos.writeUTF(message);
        dos.writeBoolean(Boolean.TRUE);
        out.write(hdos.toByteArray());
        out.flush();
    }

    protected static void writeServerMember(DistributedMember member, DataOutputStream dos) throws IOException {
        Version v = Version.CURRENT;
        if (dos instanceof VersionedDataStream) {
            v = ((VersionedDataStream)((Object)dos)).getVersion();
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream(v);
        DataSerializer.writeObject(member, hdos);
        DataSerializer.writeByteArray(hdos.toByteArray(), dos);
        hdos.close();
    }

    private static boolean readGFEHandshake(ServerConnection connection, Version clientVersion, SecurityService securityService) {
        int handShakeTimeout = connection.getHandShakeTimeout();
        InternalLogWriter securityLogWriter = connection.getSecurityLogWriter();
        try {
            Socket socket = connection.getSocket();
            DistributedSystem system = connection.getDistributedSystem();
            HandShake handshake = new HandShake(socket, handShakeTimeout, system, clientVersion, connection.getCommunicationMode(), securityService);
            connection.setHandshake(handshake);
            ClientProxyMembershipID proxyId = handshake.getMembership();
            connection.setProxyId(proxyId);
            if (clientVersion.compareTo(Version.GFE_65) < 0 || connection.getCommunicationMode().isWAN()) {
                long uniqueId = ServerHandShakeProcessor.setAuthAttributes(connection);
                connection.setUserAuthId(uniqueId);
            }
        }
        catch (SocketTimeoutException timeout) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.ServerHandShakeProcessor_0_HANDSHAKE_REPLY_CODE_TIMEOUT_NOT_RECEIVED_WITH_IN_1_MS, new Object[]{connection.getName(), handShakeTimeout}));
            connection.stats.incFailedConnectionAttempts();
            connection.cleanup();
            return false;
        }
        catch (EOFException e) {
            logger.info("{} {}", (Object)connection.getName(), (Object)e);
            connection.stats.incFailedConnectionAttempts();
            connection.cleanup();
            return false;
        }
        catch (SocketException e) {
            logger.info("{} {}", (Object)connection.getName(), (Object)e);
            connection.stats.incFailedConnectionAttempts();
            connection.cleanup();
            return false;
        }
        catch (IOException e) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.ServerHandShakeProcessor_0_RECEIVED_NO_HANDSHAKE_REPLY_CODE, connection.getName()), (Throwable)e);
            connection.stats.incFailedConnectionAttempts();
            connection.cleanup();
            return false;
        }
        catch (AuthenticationRequiredException noauth) {
            String exStr = noauth.getLocalizedMessage();
            if (noauth.getCause() != null) {
                exStr = exStr + " : " + noauth.getCause().getLocalizedMessage();
            }
            if (securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(LocalizedStrings.ONE_ARG, connection.getName() + ": Security exception: " + exStr);
            }
            connection.stats.incFailedConnectionAttempts();
            connection.refuseHandshake(noauth.getMessage(), (byte)62);
            connection.cleanup();
            return false;
        }
        catch (AuthenticationFailedException failed) {
            String exStr = failed.getLocalizedMessage();
            if (failed.getCause() != null) {
                exStr = exStr + " : " + failed.getCause().getLocalizedMessage();
            }
            if (securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(LocalizedStrings.ONE_ARG, connection.getName() + ": Security exception: " + exStr);
            }
            connection.stats.incFailedConnectionAttempts();
            connection.refuseHandshake(failed.getMessage(), (byte)63);
            connection.cleanup();
            return false;
        }
        catch (Exception ex) {
            logger.warn("{} {}", (Object)connection.getName(), (Object)ex.getLocalizedMessage());
            connection.stats.incFailedConnectionAttempts();
            connection.refuseHandshake(ex.getMessage(), (byte)60);
            connection.cleanup();
            return false;
        }
        return true;
    }

    public static long setAuthAttributes(ServerConnection connection) throws Exception {
        long uniqueId;
        logger.debug("setAttributes()");
        Object principal = ((HandShake)connection.getHandshake()).verifyCredentials();
        if (principal instanceof Subject) {
            uniqueId = ServerConnection.getClientUserAuths(connection.getProxyID()).putSubject((Subject)principal);
        } else {
            uniqueId = ServerHandShakeProcessor.getUniqueId(connection, (Principal)principal);
            connection.setPrincipal((Principal)principal);
        }
        return uniqueId;
    }

    public static long getUniqueId(ServerConnection connection, Principal principal) throws Exception {
        InternalLogWriter securityLogWriter = connection.getSecurityLogWriter();
        DistributedSystem system = connection.getDistributedSystem();
        Properties systemProperties = system.getProperties();
        String authzFactoryName = systemProperties.getProperty("security-client-accessor");
        String postAuthzFactoryName = systemProperties.getProperty("security-client-accessor-pp");
        AuthorizeRequest authzRequest = null;
        AuthorizeRequestPP postAuthzRequest = null;
        if (authzFactoryName != null && authzFactoryName.length() > 0) {
            if (securityLogWriter.fineEnabled()) {
                securityLogWriter.fine(connection.getName() + ": Setting pre-process authorization callback to: " + authzFactoryName);
            }
            if (principal == null && securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(LocalizedStrings.ServerHandShakeProcessor_0_AUTHORIZATION_ENABLED_BUT_AUTHENTICATION_CALLBACK_1_RETURNED_WITH_NULL_CREDENTIALS_FOR_PROXYID_2, new Object[]{connection.getName(), "security-client-authenticator", connection.getProxyID()});
            }
            authzRequest = new AuthorizeRequest(authzFactoryName, connection.getProxyID(), principal, (Cache)connection.getCache());
        }
        if (postAuthzFactoryName != null && postAuthzFactoryName.length() > 0) {
            if (securityLogWriter.fineEnabled()) {
                securityLogWriter.fine(connection.getName() + ": Setting post-process authorization callback to: " + postAuthzFactoryName);
            }
            if (principal == null && securityLogWriter.warningEnabled()) {
                securityLogWriter.warning(LocalizedStrings.ServerHandShakeProcessor_0_POSTPROCESS_AUTHORIZATION_ENABLED_BUT_NO_AUTHENTICATION_CALLBACK_2_IS_CONFIGURED, new Object[]{connection.getName(), "security-client-authenticator"});
            }
            postAuthzRequest = new AuthorizeRequestPP(postAuthzFactoryName, connection.getProxyID(), principal, connection.getCache());
        }
        return connection.setUserAuthorizeAndPostAuthorizeRequest(authzRequest, postAuthzRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Version readClientVersion(ServerConnection connection) throws IOException, VersionException {
        Socket socket = connection.getSocket();
        int timeout = connection.getHandShakeTimeout();
        int soTimeout = -1;
        try {
            soTimeout = socket.getSoTimeout();
            socket.setSoTimeout(timeout);
            InputStream is = socket.getInputStream();
            short clientVersionOrdinal = Version.readOrdinalFromInputStream(is);
            if (clientVersionOrdinal == -1) {
                throw new EOFException(LocalizedStrings.ServerHandShakeProcessor_HANDSHAKEREADER_EOF_REACHED_BEFORE_CLIENT_VERSION_COULD_BE_READ.toLocalizedString());
            }
            Version clientVersion = null;
            try {
                clientVersion = Version.fromOrdinal(clientVersionOrdinal, true);
            }
            catch (UnsupportedVersionException uve) {
                if (connection.getCommunicationMode().isWAN()) {
                    Version version = Acceptor.VERSION;
                    if (soTimeout != -1) {
                        try {
                            socket.setSoTimeout(soTimeout);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return version;
                }
                SocketAddress sa = socket.getRemoteSocketAddress();
                String sInfo = "";
                if (sa != null) {
                    sInfo = " Client: " + sa.toString() + ".";
                }
                throw new UnsupportedVersionException(uve.getMessage() + sInfo);
            }
            if (!clientVersion.compatibleWith(Acceptor.VERSION)) {
                throw new IncompatibleVersionException(clientVersion, Acceptor.VERSION);
            }
            Version version = clientVersion;
            return version;
        }
        finally {
            if (soTimeout != -1) {
                try {
                    socket.setSoTimeout(soTimeout);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

