/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;

public class EndBucketCreationMessage
extends PartitionMessage {
    private int bucketId;
    private InternalDistributedMember newPrimary;

    public EndBucketCreationMessage() {
    }

    private EndBucketCreationMessage(Collection<InternalDistributedMember> recipients, int regionId, ReplyProcessor21 processor, int bucketId, InternalDistributedMember newPrimary) {
        super(recipients, regionId, processor);
        this.bucketId = bucketId;
        this.newPrimary = newPrimary;
    }

    public static void send(Collection<InternalDistributedMember> acceptedMembers, InternalDistributedMember newPrimary, PartitionedRegion pr, int bid) {
        Assert.assertTrue(newPrimary != null, "VolunteerPrimaryBucketMessage NULL recipient");
        ReplyProcessor21 response = new ReplyProcessor21(pr.getSystem(), acceptedMembers);
        EndBucketCreationMessage msg = new EndBucketCreationMessage(acceptedMembers, pr.getPRId(), response, bid, newPrimary);
        pr.getDistributionManager().putOutgoing(msg);
    }

    public EndBucketCreationMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        try {
            region.getRedundancyProvider().endBucketCreationLocally(this.bucketId, this.newPrimary);
        }
        finally {
            region.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; newPrimary=").append(this.newPrimary);
    }

    @Override
    public int getDSFID() {
        return 2113;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.newPrimary = new InternalDistributedMember();
        InternalDataSerializer.invokeFromData(this.newPrimary, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        InternalDataSerializer.invokeToData(this.newPrimary, out);
    }
}

