/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.ha;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.CancelException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;

public class HAContainerRegion
implements HAContainerWrapper {
    private Region map;
    private final Map<String, CacheClientProxy> haRegionNameToProxy;

    public HAContainerRegion(Region region) {
        this.map = region;
        this.haRegionNameToProxy = new ConcurrentHashMap<String, CacheClientProxy>();
    }

    @Override
    public ClientProxyMembershipID getProxyID(String haRegionName) {
        CacheClientProxy proxy = this.haRegionNameToProxy.get(haRegionName);
        if (proxy != null) {
            return proxy.getProxyID();
        }
        return null;
    }

    public Region getMapForTest() {
        Region region = this.map;
        return region;
    }

    @Override
    public Object putProxy(String haName, CacheClientProxy proxy) {
        return this.haRegionNameToProxy.put(haName, proxy);
    }

    @Override
    public CacheClientProxy getProxy(String haName) {
        return this.haRegionNameToProxy.get(haName);
    }

    @Override
    public Object removeProxy(String haName) {
        return this.haRegionNameToProxy.remove(haName);
    }

    @Override
    public Object getKey(Object key) {
        Region.Entry entry = this.map.getEntry(key);
        if (entry != null) {
            try {
                return entry.getKey();
            }
            catch (EntryDestroyedException ede) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.map.getName();
    }

    @Override
    public void cleanUp() {
        try {
            this.map.destroyRegion();
        }
        catch (CancelException cancelException) {
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object key) {
        ClientUpdateMessageImpl msg = (ClientUpdateMessageImpl)this.map.get(key);
        if (msg != null) {
            msg.setEventIdentifier(((HAEventWrapper)key).getEventId());
            if (msg.hasCqs()) {
                msg.setClientCqs(((HAEventWrapper)key).getClientCqs());
            }
        }
        return msg;
    }

    @Override
    public Object getEntry(Object key) {
        Region.Entry entry = this.map.getEntry(key);
        if (entry != null) {
            ClientUpdateMessageImpl msg = (ClientUpdateMessageImpl)entry.getValue();
            msg.setEventIdentifier(((HAEventWrapper)key).getEventId());
            if (msg.hasCqs()) {
                msg.setClientCqs(((HAEventWrapper)key).getClientCqs());
            }
        }
        return entry;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.map.putIfAbsent(key, value);
    }

    public void putAll(Map t) {
        this.map.putAll(t);
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }
}

