/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Set;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TransactionDataRebalancedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.SetUtils;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DefaultResultCollector;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class PartitionedRegionFunctionExecutor
extends AbstractExecution {
    private final PartitionedRegion pr;
    private ServerToClientFunctionResultSender sender;
    private boolean executeOnBucketSet = false;
    private boolean isPRSingleHop = false;

    public PartitionedRegionFunctionExecutor(Region r) {
        if (r == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("region"));
        }
        this.pr = (PartitionedRegion)r;
    }

    private PartitionedRegionFunctionExecutor(PartitionedRegionFunctionExecutor prfe) {
        super(prfe);
        this.pr = prfe.pr;
        this.executeOnBucketSet = prfe.executeOnBucketSet;
        this.isPRSingleHop = prfe.isPRSingleHop;
        this.isReExecute = prfe.isReExecute;
        if (prfe.filter != null) {
            this.filter.clear();
            this.filter.addAll(prfe.filter);
        }
        if (prfe.sender != null) {
            this.sender = prfe.sender;
        }
    }

    private PartitionedRegionFunctionExecutor(PartitionedRegionFunctionExecutor prfe, MemberMappedArgument argument) {
        super(prfe);
        this.pr = prfe.pr;
        this.executeOnBucketSet = prfe.executeOnBucketSet;
        this.isPRSingleHop = prfe.isPRSingleHop;
        this.filter.clear();
        this.filter.addAll(prfe.filter);
        this.sender = prfe.sender;
        this.memberMappedArg = argument;
        this.isMemberMappedArgument = true;
    }

    private PartitionedRegionFunctionExecutor(PartitionedRegionFunctionExecutor prfe, ResultCollector rs) {
        super(prfe);
        this.pr = prfe.pr;
        this.executeOnBucketSet = prfe.executeOnBucketSet;
        this.isPRSingleHop = prfe.isPRSingleHop;
        this.filter.clear();
        this.filter.addAll(prfe.filter);
        this.sender = prfe.sender;
        this.rc = rs;
    }

    private PartitionedRegionFunctionExecutor(PartitionedRegionFunctionExecutor prfe, Object arguments) {
        super(prfe);
        this.pr = prfe.pr;
        this.executeOnBucketSet = prfe.executeOnBucketSet;
        this.isPRSingleHop = prfe.isPRSingleHop;
        this.filter.clear();
        this.filter.addAll(prfe.filter);
        this.sender = prfe.sender;
        this.args = arguments;
    }

    private PartitionedRegionFunctionExecutor(PartitionedRegionFunctionExecutor prfe, Set filter2) {
        super(prfe);
        this.pr = prfe.pr;
        this.executeOnBucketSet = prfe.executeOnBucketSet;
        this.isPRSingleHop = prfe.isPRSingleHop;
        this.sender = prfe.sender;
        this.filter.clear();
        this.filter.addAll(filter2);
        this.isReExecute = prfe.isReExecute;
    }

    private PartitionedRegionFunctionExecutor(PartitionedRegionFunctionExecutor prfe, Set<Integer> bucketsAsFilter, boolean executeOnBucketSet) {
        super(prfe);
        this.pr = prfe.pr;
        this.executeOnBucketSet = executeOnBucketSet;
        this.isPRSingleHop = prfe.isPRSingleHop;
        this.sender = prfe.sender;
        this.filter.clear();
        this.filter.addAll(bucketsAsFilter);
        this.isReExecute = prfe.isReExecute;
    }

    private PartitionedRegionFunctionExecutor(PartitionedRegionFunctionExecutor prfe, boolean isReExecute) {
        super(prfe);
        this.pr = prfe.pr;
        this.executeOnBucketSet = prfe.executeOnBucketSet;
        this.isPRSingleHop = prfe.isPRSingleHop;
        if (prfe.filter != null) {
            this.filter.clear();
            this.filter.addAll(prfe.filter);
        }
        if (prfe.sender != null) {
            this.sender = prfe.sender;
        }
        this.isReExecute = isReExecute;
        this.isClientServerMode = prfe.isClientServerMode;
        if (prfe.failedNodes != null) {
            this.failedNodes.clear();
            this.failedNodes.addAll(prfe.failedNodes);
        }
    }

    public PartitionedRegionFunctionExecutor(PartitionedRegion region, Set filter2, Object args, MemberMappedArgument memberMappedArg, ServerToClientFunctionResultSender resultSender, Set failedNodes, boolean executeOnBucketSet) {
        this.pr = region;
        this.sender = resultSender;
        this.isClientServerMode = true;
        this.executeOnBucketSet = executeOnBucketSet;
        if (filter2 != null) {
            this.filter.clear();
            this.filter.addAll(filter2);
        }
        if (args != null) {
            this.args = args;
        } else if (memberMappedArg != null) {
            this.memberMappedArg = memberMappedArg;
            this.isMemberMappedArgument = true;
        }
        if (failedNodes != null) {
            this.failedNodes.clear();
            this.failedNodes.addAll(failedNodes);
        }
    }

    public PartitionedRegionFunctionExecutor(PartitionedRegion region, Set filter2, Object args, MemberMappedArgument memberMappedArg, ServerToClientFunctionResultSender resultSender, Set failedNodes, boolean executeOnBucketSet, boolean isPRSingleHop) {
        this.pr = region;
        this.sender = resultSender;
        this.isClientServerMode = true;
        this.executeOnBucketSet = executeOnBucketSet;
        this.isPRSingleHop = isPRSingleHop;
        if (filter2 != null) {
            this.filter.clear();
            this.filter.addAll(filter2);
        }
        if (args != null) {
            this.args = args;
        } else if (memberMappedArg != null) {
            this.memberMappedArg = memberMappedArg;
            this.isMemberMappedArgument = true;
        }
        if (failedNodes != null) {
            this.failedNodes.clear();
            this.failedNodes.addAll(failedNodes);
        }
    }

    @Override
    public ResultCollector executeFunction(Function function) {
        if (function.hasResult()) {
            if (this.rc == null) {
                return this.pr.executeFunction(function, this, new DefaultResultCollector(), this.executeOnBucketSet);
            }
            return this.pr.executeFunction(function, this, this.rc, this.executeOnBucketSet);
        }
        this.pr.executeFunction(function, this, null, this.executeOnBucketSet);
        return new NoResult();
    }

    public Execution withFilter(Set filter) {
        if (filter == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("filter"));
        }
        this.executeOnBucketSet = false;
        return new PartitionedRegionFunctionExecutor(this, filter);
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        if (bucketIDs == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("buckets as filter"));
        }
        if (bucketIDs.isEmpty()) {
            throw new FunctionException("Bucket IDs list is empty");
        }
        Set<Integer> actualBucketSet = this.pr.getRegionAdvisor().getBucketSet();
        bucketIDs.retainAll(actualBucketSet);
        for (int bid : bucketIDs) {
            if (actualBucketSet.contains(bid)) continue;
            throw new FunctionException("Bucket " + bid + " does not exist.");
        }
        if (bucketIDs.isEmpty()) {
            throw new FunctionException("No valid buckets to execute on");
        }
        return new PartitionedRegionFunctionExecutor(this, bucketIDs, true);
    }

    public LocalRegion getRegion() {
        return this.pr;
    }

    public ServerToClientFunctionResultSender getServerResultSender() {
        return this.sender;
    }

    public Execution setArguments(Object args) {
        if (args == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("args"));
        }
        return new PartitionedRegionFunctionExecutor(this, args);
    }

    public Execution withArgs(Object args) {
        return this.setArguments(args);
    }

    public Execution withCollector(ResultCollector rs) {
        if (rs == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("Result Collector"));
        }
        return new PartitionedRegionFunctionExecutor(this, rs);
    }

    @Override
    public AbstractExecution setIsReExecute() {
        return new PartitionedRegionFunctionExecutor(this, true);
    }

    public boolean isPrSingleHop() {
        return this.isPRSingleHop;
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("MemberMapped arg"));
        }
        return new PartitionedRegionFunctionExecutor(this, argument);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ PartitionedRegionFunctionExecutor:");
        buf.append("args=");
        buf.append(this.args);
        buf.append(";filter=");
        buf.append(this.filter);
        buf.append(";region=");
        buf.append(this.pr.getName());
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void validateExecution(Function function, Set targetMembers) {
        InternalCache cache = this.pr.getGemFireCache();
        if (cache != null && cache.getTxManager().getTXState() != null) {
            if (targetMembers.size() > 1) {
                throw new TransactionException(LocalizedStrings.PartitionedRegion_TX_FUNCTION_ON_MORE_THAN_ONE_NODE.toLocalizedString());
            }
            assert (targetMembers.size() == 1);
            DistributedMember funcTarget = (DistributedMember)targetMembers.iterator().next();
            DistributedMember target = cache.getTxManager().getTXState().getTarget();
            if (target == null) {
                cache.getTxManager().getTXState().setTarget(funcTarget);
            } else if (!target.equals(funcTarget)) {
                throw new TransactionDataRebalancedException(LocalizedStrings.PartitionedRegion_TX_FUNCTION_EXECUTION_NOT_COLOCATED_0_1.toLocalizedString(target, funcTarget));
            }
        }
        if (function.optimizeForWrite() && cache.getInternalResourceManager().getHeapMonitor().containsHeapCriticalMembers(targetMembers) && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
            Set<InternalDistributedMember> hcm = cache.getResourceAdvisor().adviseCritialMembers();
            Set sm = SetUtils.intersection(hcm, targetMembers);
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(function.getId(), sm), sm);
        }
    }
}

