/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.util.Properties;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.eviction.CachedDeserializableValueWrapper;
import org.apache.geode.internal.cache.eviction.EvictionStatistics;
import org.apache.geode.internal.cache.eviction.SizeLRUController;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.size.Sizeable;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class MemoryLRUController
extends SizeLRUController
implements Declarable {
    private static final long serialVersionUID = 6364183985590572514L;
    private static final int OVERHEAD_PER_ENTRY = 250;
    private static final String MAXIMUM_MEGABYTES = "maximum-megabytes";
    private static final String SIZER_IMPL = "sizer";
    private static final long ONE_MEG = 0x100000L;
    protected static final StatisticsType statType;
    private long limit = 0xA00000L;
    private int perEntryOverHead = 250;
    private final boolean isOffHeap;

    public MemoryLRUController(Region region) {
        this(10, region);
    }

    public MemoryLRUController(int megabytes, Region region) {
        this(megabytes, null, region);
    }

    public MemoryLRUController(int megabytes, ObjectSizer sizerImpl, Region region) {
        this(megabytes, sizerImpl, EvictionAction.DEFAULT_EVICTION_ACTION, region, false);
    }

    public MemoryLRUController(int megabytes, ObjectSizer sizer, EvictionAction evictionAction, Region region, boolean isOffHeap) {
        super(evictionAction, region, sizer);
        this.isOffHeap = isOffHeap;
        this.setMaximumMegabytes(megabytes);
    }

    @Override
    public void init(Properties props) {
        String prop;
        String sizerStr = props.getProperty(SIZER_IMPL);
        if (sizerStr != null) {
            try {
                Class<?> c = ClassPathLoader.getLatest().forName(sizerStr);
                this.setSizer((ObjectSizer)c.newInstance());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(LocalizedStrings.MemLRUCapacityController_COULD_NOT_CREATE_SIZER_INSTANCE_GIVEN_THE_CLASS_NAME_0.toLocalizedString(sizerStr), e);
            }
        }
        if ((prop = props.getProperty(MAXIMUM_MEGABYTES)) != null) {
            this.limit = (long)Integer.parseInt(prop) * 0x100000L;
        }
        if ((prop = props.getProperty("eviction-action")) != null) {
            this.setEvictionAction(EvictionAction.parseAction(prop));
        }
    }

    public void setMaximumMegabytes(int megabytes) {
        if (megabytes <= 0) {
            throw new IllegalArgumentException(LocalizedStrings.MemLRUCapacityController_MEMLRUCONTROLLER_LIMIT_MUST_BE_POSTIVE_0.toLocalizedString(megabytes));
        }
        this.limit = (long)megabytes * 0x100000L;
        if (this.bucketRegion != null) {
            this.bucketRegion.setLimit(this.limit);
        } else if (this.stats != null) {
            this.stats.setLimit(this.limit);
        }
    }

    @Override
    public void setLimit(int maximum) {
        this.setMaximumMegabytes(maximum);
    }

    public void setEntryOverHead(int entryOverHead) {
        this.perEntryOverHead = entryOverHead;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public EvictionAlgorithm getEvictionAlgorithm() {
        return EvictionAlgorithm.LRU_MEMORY;
    }

    @Override
    public int entrySize(Object key, Object value) throws IllegalArgumentException {
        if (value == Token.TOMBSTONE) {
            return 0;
        }
        int size = 0;
        int keySize = 0;
        if (!this.isOffHeap) {
            size += this.getPerEntryOverhead();
            keySize = this.sizeof(key);
        }
        int valueSize = this.sizeof(value);
        size += keySize;
        return size += valueSize;
    }

    @Override
    public StatisticsType getStatisticsType() {
        return statType;
    }

    @Override
    public String getStatisticsName() {
        return "MemLRUStatistics";
    }

    @Override
    public int getLimitStatId() {
        return statType.nameToId("bytesAllowed");
    }

    @Override
    public int getCountStatId() {
        return statType.nameToId("byteCount");
    }

    @Override
    public int getEvictionsStatId() {
        return statType.nameToId("lruEvictions");
    }

    @Override
    public int getDestroysStatId() {
        return statType.nameToId("lruDestroys");
    }

    @Override
    public int getDestroysLimitStatId() {
        return statType.nameToId("lruDestroysLimit");
    }

    @Override
    public int getEvaluationsStatId() {
        return statType.nameToId("lruEvaluations");
    }

    @Override
    public int getGreedyReturnsStatId() {
        return statType.nameToId("lruGreedyReturns");
    }

    @Override
    public boolean mustEvict(EvictionStatistics stats, InternalRegion region, int delta) {
        return stats.getCounter() + (long)delta > stats.getLimit();
    }

    @Override
    public boolean lruLimitExceeded(EvictionStatistics stats, DiskRegionView diskRegionView) {
        return stats.getCounter() > stats.getLimit();
    }

    static int basicSizeof(Object o, ObjectSizer sizer) throws IllegalArgumentException {
        boolean cdChangingForm = o instanceof CachedDeserializableValueWrapper;
        if (cdChangingForm) {
            o = ((CachedDeserializableValueWrapper)o).getValue();
        }
        if (o == null || o == Token.INVALID || o == Token.LOCAL_INVALID || o == Token.DESTROYED || o == Token.TOMBSTONE) {
            return 0;
        }
        int size = o instanceof byte[] || o instanceof String ? ObjectSizer.DEFAULT.sizeof(o) : (o instanceof Sizeable ? ((Sizeable)o).getSizeInBytes() : (sizer != null ? sizer.sizeof(o) : ObjectSizer.DEFAULT.sizeof(o)));
        if (cdChangingForm) {
            size += CachedDeserializableFactory.overhead();
        }
        return size;
    }

    public int getPerEntryOverhead() {
        return this.perEntryOverHead;
    }

    @Override
    public boolean equals(Object cc) {
        if (!super.equals(cc)) {
            return false;
        }
        MemoryLRUController other = (MemoryLRUController)cc;
        return this.limit == other.limit;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = (int)((long)result + this.limit);
        return result;
    }

    @Override
    public String toString() {
        return "MemLRUCapacityController with a capacity of " + this.getLimit() + " megabytes and and eviction action " + this.getEvictionAction();
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String bytesAllowedDesc = "Number of total bytes allowed in this region.";
        String byteCountDesc = "Number of bytes in region.";
        String lruEvictionsDesc = "Number of total entry evictions triggered by LRU.";
        String lruDestroysDesc = "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.";
        String lruDestroysLimitDesc = "Maximum number of entry destroys triggered by LRU before scan occurs.";
        String lruEvaluationsDesc = "Number of entries evaluated during LRU operations.";
        String lruGreedyReturnsDesc = "Number of non-LRU entries evicted during LRU operations";
        statType = f.createType("MemLRUStatistics", "Statistics about byte based Least Recently Used region entry disposal", new StatisticDescriptor[]{f.createLongGauge("bytesAllowed", "Number of total bytes allowed in this region.", "bytes"), f.createLongGauge("byteCount", "Number of bytes in region.", "bytes"), f.createLongCounter("lruEvictions", "Number of total entry evictions triggered by LRU.", "entries"), f.createLongCounter("lruDestroys", "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.", "entries"), f.createLongGauge("lruDestroysLimit", "Maximum number of entry destroys triggered by LRU before scan occurs.", "entries"), f.createLongCounter("lruEvaluations", "Number of entries evaluated during LRU operations.", "entries"), f.createLongCounter("lruGreedyReturns", "Number of non-LRU entries evicted during LRU operations", "entries")});
    }
}

