/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.eviction.EvictionStatistics;
import org.apache.geode.internal.cache.eviction.EvictionStatisticsImpl;
import org.apache.geode.internal.cache.eviction.SizeLRUController;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class HeapLRUController
extends SizeLRUController {
    private static final long serialVersionUID = 4970685814429530675L;
    public static final String TOP_UP_HEAP_EVICTION_PERCENTAGE_PROPERTY = "gemfire.topUpHeapEvictionPercentage";
    private static final int PER_ENTRY_OVERHEAD = 250;
    private int perEntryOverhead = 250;
    private static final StatisticsType statType;

    public HeapLRUController(EvictionAction evictionAction, Region region, ObjectSizer sizer) {
        super(evictionAction, region, sizer);
    }

    @Override
    public void setLimit(int maximum) {
    }

    @Override
    public long getLimit() {
        return 0L;
    }

    @Override
    public String toString() {
        return LocalizedStrings.HeapLRUCapacityController_HEAPLRUCAPACITYCONTROLLER_WITH_A_CAPACITY_OF_0_OF_HEAP_AND_AN_THREAD_INTERVAL_OF_1_AND_EVICTION_ACTION_2.toLocalizedString(this.getLimit(), this.getEvictionAction());
    }

    @Override
    public EvictionAlgorithm getEvictionAlgorithm() {
        return EvictionAlgorithm.LRU_HEAP;
    }

    @Override
    public int entrySize(Object key, Object value) throws IllegalArgumentException {
        if (value == Token.TOMBSTONE) {
            return 0;
        }
        int size = this.getPerEntryOverhead();
        size += this.sizeof(key);
        return size += this.sizeof(value);
    }

    @Override
    public EvictionStatistics initStats(Object region, StatisticsFactory statsFactory) {
        this.setRegionName(region);
        EvictionStatisticsImpl stats = new EvictionStatisticsImpl(statsFactory, this.getRegionName(), this);
        this.setStatistics(stats);
        return stats;
    }

    @Override
    public StatisticsType getStatisticsType() {
        return statType;
    }

    @Override
    public String getStatisticsName() {
        return "HeapLRUStatistics";
    }

    @Override
    public int getLimitStatId() {
        throw new UnsupportedOperationException("Limit not used with this LRU type");
    }

    @Override
    public int getCountStatId() {
        return statType.nameToId("entryBytes");
    }

    @Override
    public int getEvictionsStatId() {
        return statType.nameToId("lruEvictions");
    }

    @Override
    public int getDestroysStatId() {
        return statType.nameToId("lruDestroys");
    }

    @Override
    public int getDestroysLimitStatId() {
        return statType.nameToId("lruDestroysLimit");
    }

    @Override
    public int getEvaluationsStatId() {
        return statType.nameToId("lruEvaluations");
    }

    @Override
    public int getGreedyReturnsStatId() {
        return statType.nameToId("lruGreedyReturns");
    }

    @Override
    public boolean mustEvict(EvictionStatistics stats, InternalRegion region, int delta) {
        InternalCache cache = (InternalCache)region.getRegionService();
        boolean offheap = region.getAttributes().getOffHeap();
        boolean shouldEvict = cache.getInternalResourceManager().getMemoryMonitor(offheap).getState().isEviction();
        if (region instanceof BucketRegion) {
            return shouldEvict && ((BucketRegion)region).getSizeForEviction() > 0;
        }
        return shouldEvict && ((LocalRegion)region).getRegionMap().sizeInVM() > 0;
    }

    @Override
    public boolean lruLimitExceeded(EvictionStatistics stats, DiskRegionView diskRegionView) {
        InternalResourceManager resourceManager = diskRegionView.getDiskStore().getCache().getInternalResourceManager();
        return resourceManager.getMemoryMonitor(diskRegionView.getOffHeap()).getState().isEviction();
    }

    public int getPerEntryOverhead() {
        return this.perEntryOverhead;
    }

    public void setEntryOverHead(int entryOverHead) {
        this.perEntryOverhead = entryOverHead;
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String entryBytesDesc = "The amount of memory currently used by regions configured for eviction.";
        String lruEvictionsDesc = "Number of total entry evictions triggered by LRU.";
        String lruDestroysDesc = "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.";
        String lruDestroysLimitDesc = "Maximum number of entry destroys triggered by LRU before scan occurs.";
        String lruEvaluationsDesc = "Number of entries evaluated during LRU operations.";
        String lruGreedyReturnsDesc = "Number of non-LRU entries evicted during LRU operations";
        statType = f.createType("HeapLRUStatistics", "Statistics about byte based Least Recently Used region entry disposal", new StatisticDescriptor[]{f.createLongGauge("entryBytes", "The amount of memory currently used by regions configured for eviction.", "bytes"), f.createLongCounter("lruEvictions", "Number of total entry evictions triggered by LRU.", "entries"), f.createLongCounter("lruDestroys", "Number of entries destroyed in the region through both destroy cache operations and eviction. Reset to zero each time it exceeds lruDestroysLimit.", "entries"), f.createLongGauge("lruDestroysLimit", "Maximum number of entry destroys triggered by LRU before scan occurs.", "entries"), f.createLongCounter("lruEvaluations", "Number of entries evaluated during LRU operations.", "entries"), f.createLongCounter("lruGreedyReturns", "Number of non-LRU entries evicted during LRU operations", "entries")});
    }
}

