/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.InternalEvictionStatistics;

class EvictionStatisticsImpl
implements InternalEvictionStatistics {
    private final Statistics stats;
    private final int limitId;
    private final int destroysLimitId;
    private final int counterId;
    private final int evictionsId;
    private final int destroysId;
    private final int evaluationsId;
    private final int greedyReturnsId;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong limit = new AtomicLong();
    private final AtomicLong destroysLimit = new AtomicLong();
    private final AtomicLong destroys = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();

    public EvictionStatisticsImpl(StatisticsFactory factory, String name, EvictionController helper) {
        String statName = helper.getStatisticsName() + "-" + name;
        this.stats = factory.createAtomicStatistics(helper.getStatisticsType(), statName);
        this.limitId = helper.getEvictionAlgorithm().isLRUHeap() ? 0 : helper.getLimitStatId();
        this.destroysLimitId = helper.getDestroysLimitStatId();
        this.counterId = helper.getCountStatId();
        this.evictionsId = helper.getEvictionsStatId();
        this.destroysId = helper.getDestroysStatId();
        this.evaluationsId = helper.getEvaluationsStatId();
        this.greedyReturnsId = helper.getGreedyReturnsStatId();
    }

    @Override
    public void incEvictions() {
        this.evictions.getAndAdd(1L);
        this.stats.incLong(this.evictionsId, 1L);
    }

    @Override
    public long getCounter() {
        return this.counter.get();
    }

    @Override
    public long getLimit() {
        return this.limit.get();
    }

    @Override
    public void updateCounter(long delta) {
        if (delta != 0L) {
            this.counter.getAndAdd(delta);
            this.stats.incLong(this.counterId, delta);
        }
    }

    @Override
    public long getEvictions() {
        return this.evictions.get();
    }

    @Override
    public Statistics getStats() {
        return this.stats;
    }

    @Override
    public void incDestroys() {
        this.destroys.getAndAdd(1L);
        this.stats.incLong(this.destroysId, 1L);
    }

    @Override
    public void close() {
        this.stats.close();
    }

    @Override
    public void setLimit(long newValue) {
        Assert.assertTrue(newValue > 0L, "limit must be positive, an attempt was made to set it to: " + newValue);
        long oldValue = this.limit.get();
        if (oldValue != newValue) {
            this.limit.set(newValue);
            this.stats.setLong(this.limitId, newValue);
        }
    }

    @Override
    public void setDestroysLimit(long newValue) {
        Assert.assertTrue(newValue > 0L, "destroys limit must be positive, an attempt was made to set it to: " + newValue);
        long oldValue = this.destroysLimit.get();
        if (oldValue != newValue) {
            this.destroysLimit.set(newValue);
            this.stats.setLong(this.destroysLimitId, newValue);
        }
    }

    @Override
    public long getDestroysLimit() {
        return this.destroysLimit.get();
    }

    @Override
    public void resetCounter() {
        if (this.counter.get() != 0L) {
            this.counter.set(0L);
            this.stats.setLong(this.counterId, 0L);
        }
    }

    @Override
    public void decrementCounter(long delta) {
        if (delta != 0L) {
            this.counter.addAndGet(-delta);
            this.stats.setLong(this.counterId, this.counter.get());
        }
    }

    @Override
    public void incEvictions(long delta) {
        this.evictions.getAndAdd(delta);
        this.stats.incLong(this.evictionsId, delta);
    }

    @Override
    public long getDestroys() {
        return this.destroys.get();
    }

    @Override
    public void incEvaluations(long evaluations) {
        this.stats.incLong(this.evaluationsId, evaluations);
    }

    @Override
    public void incGreedyReturns(long greedyReturns) {
        this.stats.incLong(this.greedyReturnsId, greedyReturns);
    }
}

